/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.plugin.bigquery.BigQueryColumnHandle;
import com.facebook.presto.plugin.bigquery.BigQueryConfig;
import com.facebook.presto.plugin.bigquery.BigQueryEmptySplitPageSource;
import com.facebook.presto.plugin.bigquery.BigQueryResultPageSource;
import com.facebook.presto.plugin.bigquery.BigQuerySplit;
import com.facebook.presto.plugin.bigquery.BigQueryStorageClientFactory;
import com.facebook.presto.plugin.bigquery.BigQueryTableHandle;
import com.facebook.presto.plugin.bigquery.BigQueryTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;

public class BigQueryPageSourceProvider
implements ConnectorPageSourceProvider {
    private static final Logger log = Logger.get(BigQueryPageSourceProvider.class);
    private final BigQueryStorageClientFactory bigQueryStorageClientFactory;
    private final int maxReadRowsRetries;

    @Inject
    public BigQueryPageSourceProvider(BigQueryStorageClientFactory bigQueryStorageClientFactory, BigQueryConfig config) {
        this.bigQueryStorageClientFactory = bigQueryStorageClientFactory;
        this.maxReadRowsRetries = config.getMaxReadRowsRetries();
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableLayoutHandle layout, List<ColumnHandle> columns, SplitContext splitContext) {
        BigQuerySplit bigQuerySplit = (BigQuerySplit)split;
        if (bigQuerySplit.representsEmptyProjection()) {
            return new BigQueryEmptySplitPageSource(bigQuerySplit.getEmptyRowsToGenerate());
        }
        BigQueryTableLayoutHandle bigQueryTableLayoutHandle = (BigQueryTableLayoutHandle)layout;
        BigQueryTableHandle bigQueryTableHandle = bigQueryTableLayoutHandle.getTable();
        ImmutableList bigQueryColumnHandles = (ImmutableList)columns.stream().map(BigQueryColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        return new BigQueryResultPageSource(this.bigQueryStorageClientFactory, this.maxReadRowsRetries, bigQuerySplit, bigQueryTableHandle, (ImmutableList<BigQueryColumnHandle>)bigQueryColumnHandles);
    }
}

