/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.presto.plugin.bigquery.BigQueryUtil;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

public class ReadRowsHelper {
    private BigQueryStorageClient client;
    private Storage.ReadRowsRequest.Builder request;
    private int maxReadRowsRetries;

    public ReadRowsHelper(BigQueryStorageClient client, Storage.ReadRowsRequest.Builder request, int maxReadRowsRetries) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
        this.request = Objects.requireNonNull(request, "client cannot be null");
        this.maxReadRowsRetries = maxReadRowsRetries;
    }

    public Iterator<Storage.ReadRowsResponse> readRows() {
        ArrayList<Storage.ReadRowsResponse> readRowResponses = new ArrayList<Storage.ReadRowsResponse>();
        long readRowsCount = 0L;
        int retries = 0;
        Iterator<Storage.ReadRowsResponse> serverResponses = this.fetchResponses(this.request);
        while (serverResponses.hasNext()) {
            try {
                Storage.ReadRowsResponse response = serverResponses.next();
                readRowsCount += response.getRowCount();
                readRowResponses.add(response);
            }
            catch (RuntimeException e) {
                if (BigQueryUtil.isRetryable(e) && retries < this.maxReadRowsRetries) {
                    this.request.getReadPositionBuilder().setOffset(readRowsCount);
                    serverResponses = this.fetchResponses(this.request);
                    ++retries;
                    continue;
                }
                BigQueryStorageClient ignored = this.client;
                Throwable throwable = null;
                try {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (ignored != null) {
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
        return readRowResponses.iterator();
    }

    protected Iterator<Storage.ReadRowsResponse> fetchResponses(Storage.ReadRowsRequest.Builder readRowsRequest) {
        return this.client.readRowsCallable().call((Object)readRowsRequest.build()).iterator();
    }
}

