/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class BigQuerySplit
implements ConnectorSplit {
    private static final int NO_ROWS_TO_GENERATE = -1;
    private final String streamName;
    private final String avroSchema;
    private final List<ColumnHandle> columns;
    private final long emptyRowsToGenerate;

    @JsonCreator
    public BigQuerySplit(@JsonProperty(value="streamName") String streamName, @JsonProperty(value="avroSchema") String avroSchema, @JsonProperty(value="columns") List<ColumnHandle> columns, @JsonProperty(value="emptyRowsToGenerate") long emptyRowsToGenerate) {
        this.streamName = Objects.requireNonNull(streamName, "streamName cannot be null");
        this.avroSchema = Objects.requireNonNull(avroSchema, "avroSchema cannot be null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns cannot be null"));
        this.emptyRowsToGenerate = emptyRowsToGenerate;
    }

    static BigQuerySplit forStream(String streamName, String avroSchema, List<ColumnHandle> columns) {
        return new BigQuerySplit(streamName, avroSchema, columns, -1L);
    }

    static BigQuerySplit emptyProjection(long numberOfRows) {
        Preconditions.checkArgument((numberOfRows > 0L ? 1 : 0) != 0, (Object)"checkArgument must be greater than 0");
        return new BigQuerySplit("", "", (List<ColumnHandle>)ImmutableList.of(), numberOfRows);
    }

    @JsonProperty
    public String getStreamName() {
        return this.streamName;
    }

    @JsonProperty
    public String getAvroSchema() {
        return this.avroSchema;
    }

    @JsonProperty
    public List<ColumnHandle> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public long getEmptyRowsToGenerate() {
        return this.emptyRowsToGenerate;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.NO_PREFERENCE;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return ImmutableList.of();
    }

    public Object getInfo() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigQuerySplit that = (BigQuerySplit)o;
        return Objects.equals(this.streamName, that.streamName) && Objects.equals(this.avroSchema, that.avroSchema) && Objects.equals(this.columns, that.columns) && Objects.equals(this.emptyRowsToGenerate, that.emptyRowsToGenerate);
    }

    public int hashCode() {
        return Objects.hash(this.streamName, this.avroSchema, this.columns, this.emptyRowsToGenerate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("streamName", (Object)this.streamName).add("avroSchema", (Object)this.avroSchema).add("columns", this.columns).add("emptyRowsToGenerate", this.emptyRowsToGenerate).toString();
    }

    boolean representsEmptyProjection() {
        return this.emptyRowsToGenerate != -1L;
    }
}

