/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.bigquery;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.plugin.bigquery.BigQueryClient;
import com.facebook.presto.plugin.bigquery.BigQueryColumnHandle;
import com.facebook.presto.plugin.bigquery.BigQueryConfig;
import com.facebook.presto.plugin.bigquery.BigQueryErrorCode;
import com.facebook.presto.plugin.bigquery.BigQuerySplit;
import com.facebook.presto.plugin.bigquery.BigQueryStorageClientFactory;
import com.facebook.presto.plugin.bigquery.BigQueryTableHandle;
import com.facebook.presto.plugin.bigquery.BigQueryTableLayoutHandle;
import com.facebook.presto.plugin.bigquery.ReadSessionCreator;
import com.facebook.presto.plugin.bigquery.ReadSessionCreatorConfig;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TableResult;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class BigQuerySplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(BigQuerySplitManager.class);
    private final BigQueryClient bigQueryClient;
    private final BigQueryStorageClientFactory bigQueryStorageClientFactory;
    private final OptionalInt parallelism;
    private final ReadSessionCreatorConfig readSessionCreatorConfig;
    private final NodeManager nodeManager;

    @Inject
    public BigQuerySplitManager(BigQueryConfig config, BigQueryClient bigQueryClient, BigQueryStorageClientFactory bigQueryStorageClientFactory, NodeManager nodeManager) {
        Objects.requireNonNull(config, "config cannot be null");
        this.bigQueryClient = Objects.requireNonNull(bigQueryClient, "bigQueryClient cannot be null");
        this.bigQueryStorageClientFactory = Objects.requireNonNull(bigQueryStorageClientFactory, "bigQueryStorageClientFactory cannot be null");
        this.parallelism = config.getParallelism();
        this.readSessionCreatorConfig = config.createReadSessionCreatorConfig();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager cannot be null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        BigQueryTableLayoutHandle bigQueryTableLayoutHandle = (BigQueryTableLayoutHandle)layout;
        BigQueryTableHandle bigQueryTableHandle = bigQueryTableLayoutHandle.getTable();
        TableId tableId = bigQueryTableHandle.getTableId();
        int actualParallelism = this.parallelism.orElse(this.nodeManager.getRequiredWorkerNodes().size());
        Optional<String> filter = Optional.empty();
        List<BigQuerySplit> splits = this.isEmptyProjectionIsRequired(bigQueryTableHandle.getProjectedColumns()) ? this.createEmptyProjection(tableId, actualParallelism, filter) : this.readFromBigQuery(tableId, bigQueryTableHandle.getProjectedColumns(), actualParallelism, filter);
        return new FixedSplitSource(splits);
    }

    private boolean isEmptyProjectionIsRequired(Optional<List<ColumnHandle>> projectedColumns) {
        return projectedColumns.isPresent() && projectedColumns.get().isEmpty();
    }

    private ImmutableList<BigQuerySplit> readFromBigQuery(TableId tableId, Optional<List<ColumnHandle>> projectedColumns, int actualParallelism, Optional<String> filter) {
        List<ColumnHandle> columns = projectedColumns.orElse((List<ColumnHandle>)ImmutableList.of());
        ImmutableList projectedColumnsNames = (ImmutableList)columns.stream().map(column -> ((BigQueryColumnHandle)column).getName()).collect(ImmutableList.toImmutableList());
        Storage.ReadSession readSession = new ReadSessionCreator(this.readSessionCreatorConfig, this.bigQueryClient, this.bigQueryStorageClientFactory).create(tableId, (ImmutableList<String>)projectedColumnsNames, filter, actualParallelism);
        return (ImmutableList)readSession.getStreamsList().stream().map(stream -> BigQuerySplit.forStream(stream.getName(), readSession.getAvroSchema().getSchema(), columns)).collect(ImmutableList.toImmutableList());
    }

    private List<BigQuerySplit> createEmptyProjection(TableId tableId, int actualParallelism, Optional<String> filter) {
        try {
            long numberOfRows;
            if (filter.isPresent()) {
                String sql = this.bigQueryClient.createFormatSql(tableId, "COUNT(*)", new String[]{filter.get()});
                TableResult result = this.bigQueryClient.query(sql);
                numberOfRows = ((FieldValueList)result.iterateAll().iterator().next()).get(0).getLongValue();
            } else {
                numberOfRows = this.bigQueryClient.getTable(tableId).getNumRows().longValue();
            }
            long rowsPerSplit = numberOfRows / (long)actualParallelism;
            long remainingRows = numberOfRows - rowsPerSplit * (long)actualParallelism;
            List<BigQuerySplit> splits = IntStream.range(0, actualParallelism).mapToObj(ignored -> BigQuerySplit.emptyProjection(rowsPerSplit)).collect(Collectors.toList());
            splits.set(0, BigQuerySplit.emptyProjection(rowsPerSplit + remainingRows));
            return splits;
        }
        catch (BigQueryException e) {
            throw new PrestoException((ErrorCodeSupplier)BigQueryErrorCode.BIGQUERY_FAILED_TO_EXECUTE_QUERY, String.format("Failed to compute empty projection", new Object[0]), (Throwable)e);
        }
    }
}

