/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.BenchmarkResultHook;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.airlift.json.JsonCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class JsonAvgBenchmarkResultWriter
implements BenchmarkResultHook {
    private static final JsonCodec<BuildResult> JSON_CODEC = JsonCodec.jsonCodec(BuildResult.class);
    private final OutputStream outputStream;
    private int sampleCount;
    public long totalElapsedMillis;
    public long totalInputRows;
    public long totalInputRowsPerSecond;
    public long totalOutputRows;
    public long totalOutputRowsPerSecond;
    public long totalInputMegabytes;
    public long totalInputMegabytesPerSecond;

    public JsonAvgBenchmarkResultWriter(OutputStream outputStream) {
        Preconditions.checkNotNull((Object)outputStream, (Object)"outputStream is null");
        this.outputStream = outputStream;
    }

    @Override
    public BenchmarkResultHook addResults(Map<String, Long> results) {
        Preconditions.checkNotNull(results, (Object)"results is null");
        ++this.sampleCount;
        this.totalElapsedMillis += this.getValue(results, "elapsed_millis");
        this.totalInputRows += this.getValue(results, "input_rows;");
        this.totalInputRowsPerSecond += this.getValue(results, "input_rows_per_second");
        this.totalOutputRows += this.getValue(results, "output_rows");
        this.totalOutputRowsPerSecond += this.getValue(results, "output_rows_per_second");
        this.totalInputMegabytes += this.getValue(results, "input_megabytes");
        this.totalInputMegabytesPerSecond += this.getValue(results, "input_megabytes_per_second");
        return this;
    }

    private long getValue(Map<String, Long> results, String name) {
        Long value = results.get(name);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    @Override
    public void finished() {
        BuildResult average = new BuildResult();
        average.elapsedMillis += this.totalElapsedMillis / (long)this.sampleCount;
        average.inputRows += this.totalInputRows / (long)this.sampleCount;
        average.inputRowsPerSecond += this.totalInputRowsPerSecond / (long)this.sampleCount;
        average.outputRows += this.totalOutputRows / (long)this.sampleCount;
        average.outputRowsPerSecond += this.totalOutputRowsPerSecond / (long)this.sampleCount;
        average.inputMegabytes += this.totalInputRows / (long)this.sampleCount;
        average.inputMegabytesPerSecond += this.totalInputMegabytesPerSecond / (long)this.sampleCount;
        String json = JSON_CODEC.toJson((Object)average);
        try {
            this.outputStream.write(json.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class BuildResult {
        @JsonProperty
        public long elapsedMillis;
        @JsonProperty
        public long inputRows;
        @JsonProperty
        public long inputRowsPerSecond;
        @JsonProperty
        public long outputRows;
        @JsonProperty
        public long outputRowsPerSecond;
        @JsonProperty
        public long inputMegabytes;
        @JsonProperty
        public long inputMegabytesPerSecond;
    }
}

