/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSimpleOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.aggregation.DoubleSumAggregation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.util.List;

public class HandTpchQuery6
extends AbstractSimpleOperatorBenchmark {
    public HandTpchQuery6(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hand_tpch_query_6", 10, 100);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, "lineitem", "extendedprice", "discount", "shipdate", "quantity");
        FilterAndProjectOperator.FilterAndProjectOperatorFactory tpchQuery6Operator = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(1, (PageProcessor)new TpchQuery6Processor(), (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationOperator.AggregationOperatorFactory aggregationOperator = new AggregationOperator.AggregationOperatorFactory(2, AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)DoubleSumAggregation.DOUBLE_SUM.bind((List)ImmutableList.of((Object)0), Optional.absent(), Optional.absent(), 1.0)));
        return ImmutableList.of((Object)tableScanOperator, (Object)tpchQuery6Operator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HandTpchQuery6(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    public static class TpchQuery6Processor
    implements PageProcessor {
        private static final Slice MIN_SHIP_DATE = Slices.copiedBuffer((String)"1994-01-01", (Charset)Charsets.UTF_8);
        private static final Slice MAX_SHIP_DATE = Slices.copiedBuffer((String)"1995-01-01", (Charset)Charsets.UTF_8);

        public int process(ConnectorSession session, Page page, int start, int end, PageBuilder pageBuilder) {
            int position;
            Block discountBlock = page.getBlock(1);
            for (position = start; position < end; ++position) {
                if (!TpchQuery6Processor.filter(position, discountBlock, page.getBlock(2), page.getBlock(3))) continue;
                TpchQuery6Processor.project(position, pageBuilder, page.getBlock(0), discountBlock);
            }
            return position;
        }

        private static void project(int position, PageBuilder pageBuilder, Block extendedPriceBlock, Block discountBlock) {
            if (discountBlock.isNull(position) || extendedPriceBlock.isNull(position)) {
                pageBuilder.getBlockBuilder(0).appendNull();
            } else {
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), DoubleType.DOUBLE.getDouble(extendedPriceBlock, position) * DoubleType.DOUBLE.getDouble(discountBlock, position));
            }
        }

        private static boolean filter(int position, Block discountBlock, Block shipDateBlock, Block quantityBlock) {
            return !shipDateBlock.isNull(position) && VarcharType.VARCHAR.getSlice(shipDateBlock, position).compareTo(MIN_SHIP_DATE) >= 0 && !shipDateBlock.isNull(position) && VarcharType.VARCHAR.getSlice(shipDateBlock, position).compareTo(MAX_SHIP_DATE) < 0 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) >= 0.05 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) <= 0.07 && !quantityBlock.isNull(position) && BigintType.BIGINT.getLong(quantityBlock, position) < 24L;
        }
    }
}

