/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.Session;
import com.facebook.presto.benchmark.AbstractBenchmark;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.util.CpuTimer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractOperatorBenchmark
extends AbstractBenchmark {
    protected final LocalQueryRunner localQueryRunner;

    protected AbstractOperatorBenchmark(LocalQueryRunner localQueryRunner, String benchmarkName, int warmupIterations, int measuredIterations) {
        super(benchmarkName, warmupIterations, measuredIterations);
        this.localQueryRunner = (LocalQueryRunner)Preconditions.checkNotNull((Object)localQueryRunner, (Object)"localQueryRunner is null");
    }

    protected OperatorFactory createTableScanOperator(int operatorId, String tableName, String ... columnNames) {
        return this.localQueryRunner.createTableScanOperator(operatorId, tableName, columnNames);
    }

    protected OperatorFactory createHashProjectOperator(int operatorId, List<Type> types, List<Integer> hashChannels) {
        return this.localQueryRunner.createHashProjectOperator(operatorId, types, hashChannels);
    }

    protected abstract List<Driver> createDrivers(TaskContext var1);

    protected void execute(TaskContext taskContext) {
        List<Driver> drivers = this.createDrivers(taskContext);
        boolean done = false;
        while (!done) {
            boolean processed = false;
            for (Driver driver : drivers) {
                if (driver.isFinished()) continue;
                driver.process();
                processed = true;
            }
            done = !processed;
        }
    }

    @Override
    protected Map<String, Long> runOnce() {
        Session session = Session.builder().setUser("user").setSource("source").setCatalog("catalog").setSchema("schema").setTimeZoneKey(TimeZoneKey.UTC_KEY).setLocale(Locale.ENGLISH).setSystemProperties((Map)ImmutableMap.of((Object)"optimizer.optimize-hash-generation", (Object)"true")).build();
        ExecutorService executor = this.localQueryRunner.getExecutor();
        TaskContext taskContext = new TaskContext(new TaskStateMachine(new TaskId("query", "stage", "task"), (Executor)executor), (Executor)executor, session, new DataSize(256.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), false, false);
        CpuTimer cpuTimer = new CpuTimer();
        this.execute(taskContext);
        CpuTimer.CpuDuration executionTime = cpuTimer.elapsedTime();
        TaskStats taskStats = taskContext.getTaskStats();
        long inputRows = taskStats.getRawInputPositions();
        long inputBytes = taskStats.getRawInputDataSize().toBytes();
        long outputRows = taskStats.getOutputPositions();
        long outputBytes = taskStats.getOutputDataSize().toBytes();
        double inputMegaBytes = new DataSize((double)inputBytes, DataSize.Unit.BYTE).getValue(DataSize.Unit.MEGABYTE);
        return ImmutableMap.builder().put((Object)"elapsed_millis", (Object)executionTime.getWall().toMillis()).put((Object)"input_rows_per_second", (Object)((long)((double)inputRows / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"output_rows_per_second", (Object)((long)((double)outputRows / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"input_megabytes", (Object)((long)inputMegaBytes)).put((Object)"input_megabytes_per_second", (Object)((long)(inputMegaBytes / executionTime.getWall().getValue(TimeUnit.SECONDS)))).put((Object)"wall_nanos", (Object)executionTime.getWall().roundTo(TimeUnit.NANOSECONDS)).put((Object)"cpu_nanos", (Object)executionTime.getCpu().roundTo(TimeUnit.NANOSECONDS)).put((Object)"user_nanos", (Object)executionTime.getUser().roundTo(TimeUnit.NANOSECONDS)).put((Object)"input_rows", (Object)inputRows).put((Object)"input_bytes", (Object)inputBytes).put((Object)"output_rows", (Object)outputRows).put((Object)"output_bytes", (Object)outputBytes).build();
    }
}

