/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.BenchmarkResultHook;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class AverageBenchmarkResults
implements BenchmarkResultHook {
    private final Map<String, Long> resultsSum = new LinkedHashMap<String, Long>();
    private int resultsCount;

    @Override
    public BenchmarkResultHook addResults(Map<String, Long> results) {
        Preconditions.checkNotNull(results, (Object)"results is null");
        for (Map.Entry<String, Long> entry : results.entrySet()) {
            Long currentSum = this.resultsSum.get(entry.getKey());
            if (currentSum == null) {
                currentSum = 0L;
            }
            this.resultsSum.put(entry.getKey(), currentSum + entry.getValue());
        }
        ++this.resultsCount;
        return this;
    }

    public Map<String, Double> getAverageResultsValues() {
        return Maps.transformValues(this.resultsSum, (Function)new Function<Long, Double>(){

            public Double apply(@Nullable Long input) {
                return 1.0 * (double)input.longValue() / (double)AverageBenchmarkResults.this.resultsCount;
            }
        });
    }

    public Map<String, String> getAverageResultsStrings() {
        return Maps.transformValues(this.resultsSum, (Function)new Function<Long, String>(){

            public String apply(@Nullable Long input) {
                return String.format("%,3.2f", 1.0 * (double)input.longValue() / (double)AverageBenchmarkResults.this.resultsCount);
            }
        });
    }

    @Override
    public void finished() {
    }
}

