/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSimpleOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.ProjectionFunctions;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class PredicateFilterBenchmark
extends AbstractSimpleOperatorBenchmark {
    public PredicateFilterBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "predicate_filter", 5, 50);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, "orders", "totalprice");
        FilterAndProjectOperator.FilterAndProjectOperatorFactory filterAndProjectOperator = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(1, (FilterFunction)new DoubleFilter(50000.0), (Iterable)ImmutableList.of((Object)ProjectionFunctions.singleColumn((Type)DoubleType.DOUBLE, (int)0)));
        return ImmutableList.of((Object)tableScanOperator, (Object)filterAndProjectOperator);
    }

    public static void main(String[] args) {
        new PredicateFilterBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    public static class DoubleFilter
    implements FilterFunction {
        private final double minValue;

        public DoubleFilter(double minValue) {
            this.minValue = minValue;
        }

        public boolean filter(int position, Block ... blocks) {
            return DoubleType.DOUBLE.getDouble(blocks[0], position) >= this.minValue;
        }

        public boolean filter(RecordCursor cursor) {
            return cursor.getDouble(0) >= this.minValue;
        }
    }
}

