/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSimpleOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.operator.LimitOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OrderByOperator;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class OrderByBenchmark
extends AbstractSimpleOperatorBenchmark {
    private static final int ROWS = 1500000;

    public OrderByBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "in_memory_orderby_1.5M", 5, 10);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, "orders", "totalprice", "clerk");
        LimitOperator.LimitOperatorFactory limitOperator = new LimitOperator.LimitOperatorFactory(1, tableScanOperator.getTypes(), 1500000L, Optional.absent());
        OrderByOperator.OrderByOperatorFactory orderByOperator = new OrderByOperator.OrderByOperatorFactory(2, limitOperator.getTypes(), (List)ImmutableList.of((Object)1), 1500000, (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST));
        return ImmutableList.of((Object)tableScanOperator, (Object)limitOperator, (Object)orderByOperator);
    }

    public static void main(String[] args) {
        new OrderByBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

