/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSimpleOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.operator.AbstractFilterAndProjectOperator;
import com.facebook.presto.operator.AggregationFunctionDefinition;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.DoubleSumAggregation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.util.List;

public class HandTpchQuery6
extends AbstractSimpleOperatorBenchmark {
    public HandTpchQuery6(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hand_tpch_query_6", 10, 100);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, "lineitem", "extendedprice", "discount", "shipdate", "quantity");
        TpchQuery6Operator.TpchQuery6OperatorFactory tpchQuery6Operator = new TpchQuery6Operator.TpchQuery6OperatorFactory(1);
        AggregationOperator.AggregationOperatorFactory aggregationOperator = new AggregationOperator.AggregationOperatorFactory(2, AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)AggregationFunctionDefinition.aggregation((AggregationFunction)DoubleSumAggregation.DOUBLE_SUM, (List)ImmutableList.of((Object)new Input(0)), (Optional)Optional.absent(), (Optional)Optional.absent(), (double)1.0)));
        return ImmutableList.of((Object)tableScanOperator, (Object)tpchQuery6Operator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HandTpchQuery6(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    public static class TpchQuery6Operator
    extends AbstractFilterAndProjectOperator {
        private static final Slice MIN_SHIP_DATE = Slices.copiedBuffer((String)"1994-01-01", (Charset)Charsets.UTF_8);
        private static final Slice MAX_SHIP_DATE = Slices.copiedBuffer((String)"1995-01-01", (Charset)Charsets.UTF_8);

        public TpchQuery6Operator(OperatorContext operatorContext) {
            super(operatorContext, (Iterable)ImmutableList.of((Object)DoubleType.DOUBLE));
        }

        protected void filterAndProjectRowOriented(Page page, PageBuilder pageBuilder) {
            this.filterAndProjectRowOriented(pageBuilder, page.getBlock(0), page.getBlock(1), page.getBlock(2), page.getBlock(3));
        }

        private void filterAndProjectRowOriented(PageBuilder pageBuilder, Block extendedPriceBlock, Block discountBlock, Block shipDateBlock, Block quantityBlock) {
            int rows = extendedPriceBlock.getPositionCount();
            BlockCursor extendedPriceCursor = extendedPriceBlock.cursor();
            BlockCursor discountCursor = discountBlock.cursor();
            BlockCursor shipDateCursor = shipDateBlock.cursor();
            BlockCursor quantityCursor = quantityBlock.cursor();
            for (int position = 0; position < rows; ++position) {
                Preconditions.checkState((boolean)extendedPriceCursor.advanceNextPosition());
                Preconditions.checkState((boolean)discountCursor.advanceNextPosition());
                Preconditions.checkState((boolean)shipDateCursor.advanceNextPosition());
                Preconditions.checkState((boolean)quantityCursor.advanceNextPosition());
                if (!this.filter(discountCursor, shipDateCursor, quantityCursor)) continue;
                this.project(pageBuilder, extendedPriceCursor, discountCursor);
            }
            Preconditions.checkState((!extendedPriceCursor.advanceNextPosition() ? 1 : 0) != 0);
            Preconditions.checkState((!discountCursor.advanceNextPosition() ? 1 : 0) != 0);
            Preconditions.checkState((!shipDateCursor.advanceNextPosition() ? 1 : 0) != 0);
            Preconditions.checkState((!quantityCursor.advanceNextPosition() ? 1 : 0) != 0);
        }

        private void project(PageBuilder pageBuilder, BlockCursor extendedPriceCursor, BlockCursor discountCursor) {
            if (discountCursor.isNull() || extendedPriceCursor.isNull()) {
                pageBuilder.getBlockBuilder(0).appendNull();
            } else {
                pageBuilder.getBlockBuilder(0).appendDouble(extendedPriceCursor.getDouble() * discountCursor.getDouble());
            }
        }

        private boolean filter(BlockCursor discountCursor, BlockCursor shipDateCursor, BlockCursor quantityCursor) {
            return !shipDateCursor.isNull() && shipDateCursor.getSlice().compareTo(MIN_SHIP_DATE) >= 0 && !shipDateCursor.isNull() && shipDateCursor.getSlice().compareTo(MAX_SHIP_DATE) < 0 && !discountCursor.isNull() && discountCursor.getDouble() >= 0.05 && !discountCursor.isNull() && discountCursor.getDouble() <= 0.07 && !quantityCursor.isNull() && quantityCursor.getLong() < 24L;
        }

        public static class TpchQuery6OperatorFactory
        implements OperatorFactory {
            private final int operatorId;

            public TpchQuery6OperatorFactory(int operatorId) {
                this.operatorId = operatorId;
            }

            public List<Type> getTypes() {
                return ImmutableList.of((Object)DoubleType.DOUBLE);
            }

            public Operator createOperator(DriverContext driverContext) {
                OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, TpchQuery6Operator.class.getSimpleName());
                return new TpchQuery6Operator(operatorContext);
            }

            public void close() {
            }
        }
    }
}

