/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSimpleOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.operator.AggregationFunctionDefinition;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.AverageAggregations;
import com.facebook.presto.operator.aggregation.CountAggregation;
import com.facebook.presto.operator.aggregation.DoubleSumAggregation;
import com.facebook.presto.operator.aggregation.LongSumAggregation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.tree.Input;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.util.List;

public class HandTpchQuery1
extends AbstractSimpleOperatorBenchmark {
    public HandTpchQuery1(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hand_tpch_query_1", 1, 5);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, "lineitem", "returnflag", "linestatus", "quantity", "extendedprice", "discount", "tax", "shipdate");
        TpchQuery1Operator.TpchQuery1OperatorFactory tpchQuery1Operator = new TpchQuery1Operator.TpchQuery1OperatorFactory(1);
        HashAggregationOperator.HashAggregationOperatorFactory aggregationOperator = new HashAggregationOperator.HashAggregationOperatorFactory(2, (List)ImmutableList.of((Object)tpchQuery1Operator.getTypes().get(0), (Object)tpchQuery1Operator.getTypes().get(1)), Ints.asList((int[])new int[]{0, 1}), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)AggregationFunctionDefinition.aggregation((AggregationFunction)LongSumAggregation.LONG_SUM, (List)ImmutableList.of((Object)new Input(2)), (Optional)Optional.absent(), (Optional)Optional.absent(), (double)1.0), (Object)AggregationFunctionDefinition.aggregation((AggregationFunction)DoubleSumAggregation.DOUBLE_SUM, (List)ImmutableList.of((Object)new Input(3)), (Optional)Optional.absent(), (Optional)Optional.absent(), (double)1.0), (Object)AggregationFunctionDefinition.aggregation((AggregationFunction)DoubleSumAggregation.DOUBLE_SUM, (List)ImmutableList.of((Object)new Input(4)), (Optional)Optional.absent(), (Optional)Optional.absent(), (double)1.0), (Object)AggregationFunctionDefinition.aggregation((AggregationFunction)AverageAggregations.LONG_AVERAGE, (List)ImmutableList.of((Object)new Input(2)), (Optional)Optional.absent(), (Optional)Optional.absent(), (double)1.0), (Object)AggregationFunctionDefinition.aggregation((AggregationFunction)AverageAggregations.DOUBLE_AVERAGE, (List)ImmutableList.of((Object)new Input(5)), (Optional)Optional.absent(), (Optional)Optional.absent(), (double)1.0), (Object)AggregationFunctionDefinition.aggregation((AggregationFunction)AverageAggregations.DOUBLE_AVERAGE, (List)ImmutableList.of((Object)new Input(6)), (Optional)Optional.absent(), (Optional)Optional.absent(), (double)1.0), (Object)AggregationFunctionDefinition.aggregation((AggregationFunction)CountAggregation.COUNT, (List)ImmutableList.of((Object)new Input(2)), (Optional)Optional.absent(), (Optional)Optional.absent(), (double)1.0)), 10000);
        return ImmutableList.of((Object)tableScanOperator, (Object)tpchQuery1Operator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HandTpchQuery1(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    public static class TpchQuery1Operator
    implements Operator {
        private static final ImmutableList<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE);
        private final OperatorContext operatorContext;
        private final PageBuilder pageBuilder;
        private boolean finishing;
        private static final Slice MAX_SHIP_DATE = Slices.copiedBuffer((String)"1998-09-02", (Charset)Charsets.UTF_8);

        public TpchQuery1Operator(OperatorContext operatorContext) {
            this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
            this.pageBuilder = new PageBuilder(TYPES);
        }

        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        public List<Type> getTypes() {
            return TYPES;
        }

        public void finish() {
            this.finishing = true;
        }

        public boolean isFinished() {
            return this.finishing && this.pageBuilder.isEmpty();
        }

        public ListenableFuture<?> isBlocked() {
            return NOT_BLOCKED;
        }

        public boolean needsInput() {
            return !this.pageBuilder.isFull();
        }

        public void addInput(Page page) {
            Preconditions.checkNotNull((Object)page, (Object)"page is null");
            Preconditions.checkState((!this.pageBuilder.isFull() ? 1 : 0) != 0, (Object)"Output buffer is full");
            Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finished");
            this.filterAndProjectRowOriented(this.pageBuilder, page.getBlock(0), page.getBlock(1), page.getBlock(2), page.getBlock(3), page.getBlock(4), page.getBlock(5), page.getBlock(6));
        }

        public Page getOutput() {
            if (this.pageBuilder.isFull() || this.finishing && !this.pageBuilder.isEmpty()) {
                Page page = this.pageBuilder.build();
                this.pageBuilder.reset();
                return page;
            }
            return null;
        }

        private void filterAndProjectRowOriented(PageBuilder pageBuilder, Block returnFlagBlock, Block lineStatusBlock, Block quantityBlock, Block extendedPriceBlock, Block discountBlock, Block taxBlock, Block shipDateBlock) {
            int rows = returnFlagBlock.getPositionCount();
            BlockCursor returnFlagCursor = returnFlagBlock.cursor();
            BlockCursor lineStatusCursor = lineStatusBlock.cursor();
            BlockCursor quantityCursor = quantityBlock.cursor();
            BlockCursor extendedPriceCursor = extendedPriceBlock.cursor();
            BlockCursor discountCursor = discountBlock.cursor();
            BlockCursor taxCursor = taxBlock.cursor();
            BlockCursor shipDateCursor = shipDateBlock.cursor();
            for (int position = 0; position < rows; ++position) {
                Slice shipDate;
                Preconditions.checkState((boolean)returnFlagCursor.advanceNextPosition());
                Preconditions.checkState((boolean)lineStatusCursor.advanceNextPosition());
                Preconditions.checkState((boolean)quantityCursor.advanceNextPosition());
                Preconditions.checkState((boolean)extendedPriceCursor.advanceNextPosition());
                Preconditions.checkState((boolean)discountCursor.advanceNextPosition());
                Preconditions.checkState((boolean)taxCursor.advanceNextPosition());
                Preconditions.checkState((boolean)shipDateCursor.advanceNextPosition());
                if (shipDateCursor.isNull() || (shipDate = shipDateCursor.getSlice()).compareTo(MAX_SHIP_DATE) > 0) continue;
                if (returnFlagCursor.isNull()) {
                    pageBuilder.getBlockBuilder(0).appendNull();
                } else {
                    pageBuilder.getBlockBuilder(0).appendSlice(returnFlagCursor.getSlice());
                }
                if (lineStatusCursor.isNull()) {
                    pageBuilder.getBlockBuilder(1).appendNull();
                } else {
                    pageBuilder.getBlockBuilder(1).appendSlice(lineStatusCursor.getSlice());
                }
                long quantity = quantityCursor.getLong();
                double extendedPrice = extendedPriceCursor.getDouble();
                double discount = discountCursor.getDouble();
                double tax = taxCursor.getDouble();
                boolean quantityIsNull = quantityCursor.isNull();
                boolean extendedPriceIsNull = extendedPriceCursor.isNull();
                boolean discountIsNull = discountCursor.isNull();
                boolean taxIsNull = taxCursor.isNull();
                if (quantityIsNull) {
                    pageBuilder.getBlockBuilder(2).appendNull();
                } else {
                    pageBuilder.getBlockBuilder(2).appendLong(quantity);
                }
                if (extendedPriceIsNull) {
                    pageBuilder.getBlockBuilder(3).appendNull();
                } else {
                    pageBuilder.getBlockBuilder(3).appendDouble(extendedPrice);
                }
                if (extendedPriceIsNull || discountIsNull) {
                    pageBuilder.getBlockBuilder(4).appendNull();
                } else {
                    pageBuilder.getBlockBuilder(4).appendDouble(extendedPrice * (1.0 - discount));
                }
                if (extendedPriceIsNull || discountIsNull || taxIsNull) {
                    pageBuilder.getBlockBuilder(5).appendNull();
                } else {
                    pageBuilder.getBlockBuilder(5).appendDouble(extendedPrice * (1.0 - discount) * (1.0 + tax));
                }
                if (discountIsNull) {
                    pageBuilder.getBlockBuilder(6).appendNull();
                    continue;
                }
                pageBuilder.getBlockBuilder(6).appendDouble(discount);
            }
            Preconditions.checkState((!returnFlagCursor.advanceNextPosition() ? 1 : 0) != 0);
            Preconditions.checkState((!lineStatusCursor.advanceNextPosition() ? 1 : 0) != 0);
            Preconditions.checkState((!quantityCursor.advanceNextPosition() ? 1 : 0) != 0);
            Preconditions.checkState((!extendedPriceCursor.advanceNextPosition() ? 1 : 0) != 0);
            Preconditions.checkState((!discountCursor.advanceNextPosition() ? 1 : 0) != 0);
            Preconditions.checkState((!taxCursor.advanceNextPosition() ? 1 : 0) != 0);
            Preconditions.checkState((!shipDateCursor.advanceNextPosition() ? 1 : 0) != 0);
        }

        public static class TpchQuery1OperatorFactory
        implements OperatorFactory {
            private final int operatorId;

            public TpchQuery1OperatorFactory(int operatorId) {
                this.operatorId = operatorId;
            }

            public List<Type> getTypes() {
                return TYPES;
            }

            public Operator createOperator(DriverContext driverContext) {
                OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, TpchQuery1Operator.class.getSimpleName());
                return new TpchQuery1Operator(operatorContext);
            }

            public void close() {
            }
        }
    }
}

