/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.raptor.RaptorConnectorFactory;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingBlockEncodingManager;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.facebook.presto.tpch.testing.SampledTpchConnectorFactory;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Locale;
import java.util.Map;

public final class BenchmarkQueryRunner {
    private static final String TPCH_SAMPLED_CACHE_DIR = System.getProperty("tpchSampledCacheDir", "/tmp/presto_tpch/sampled_data_cache");
    private static final String TPCH_CACHE_DIR = System.getProperty("tpchCacheDir", "/tmp/presto_tpch/data_cache");

    private BenchmarkQueryRunner() {
    }

    public static LocalQueryRunner createLocalSampledQueryRunner() {
        ConnectorSession session = new ConnectorSession("user", "test", "default", "default", TimeZoneKey.UTC_KEY, Locale.ENGLISH, null, null);
        LocalQueryRunner localQueryRunner = new LocalQueryRunner(session);
        InMemoryNodeManager nodeManager = localQueryRunner.getNodeManager();
        localQueryRunner.createCatalog("tpch_sampled", (ConnectorFactory)new SampledTpchConnectorFactory((NodeManager)nodeManager, 1, 2), (Map)ImmutableMap.of());
        RaptorConnectorFactory raptorConnectorFactory = BenchmarkQueryRunner.createRaptorConnectorFactory(TPCH_SAMPLED_CACHE_DIR, (NodeManager)nodeManager);
        localQueryRunner.createCatalog("default", (ConnectorFactory)raptorConnectorFactory, (Map)ImmutableMap.of());
        MetadataManager metadata = localQueryRunner.getMetadata();
        if (!metadata.getTableHandle(session, new QualifiedTableName("default", "default", "orders")).isPresent()) {
            localQueryRunner.execute("CREATE TABLE orders AS SELECT * FROM tpch_sampled.sf1.orders");
        }
        if (!metadata.getTableHandle(session, new QualifiedTableName("default", "default", "lineitem")).isPresent()) {
            localQueryRunner.execute("CREATE TABLE lineitem AS SELECT * FROM tpch_sampled.sf1.lineitem");
        }
        return localQueryRunner;
    }

    public static LocalQueryRunner createLocalQueryRunner() {
        ConnectorSession session = new ConnectorSession("user", "test", "default", "default", TimeZoneKey.UTC_KEY, Locale.ENGLISH, null, null);
        LocalQueryRunner localQueryRunner = new LocalQueryRunner(session);
        InMemoryNodeManager nodeManager = localQueryRunner.getNodeManager();
        localQueryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory((NodeManager)nodeManager, 1), (Map)ImmutableMap.of());
        RaptorConnectorFactory raptorConnectorFactory = BenchmarkQueryRunner.createRaptorConnectorFactory(TPCH_CACHE_DIR, (NodeManager)nodeManager);
        localQueryRunner.createCatalog("default", (ConnectorFactory)raptorConnectorFactory, (Map)ImmutableMap.of());
        MetadataManager metadata = localQueryRunner.getMetadata();
        if (!metadata.getTableHandle(session, new QualifiedTableName("default", "default", "orders")).isPresent()) {
            localQueryRunner.execute("CREATE TABLE orders AS SELECT * FROM tpch.sf1.orders");
        }
        if (!metadata.getTableHandle(session, new QualifiedTableName("default", "default", "lineitem")).isPresent()) {
            localQueryRunner.execute("CREATE TABLE lineitem AS SELECT * FROM tpch.sf1.lineitem");
        }
        return localQueryRunner;
    }

    private static RaptorConnectorFactory createRaptorConnectorFactory(String cacheDir, NodeManager nodeManager) {
        try {
            File dataDir = new File(cacheDir);
            File databaseDir = new File(dataDir, "db");
            ImmutableMap config = ImmutableMap.builder().put((Object)"metadata.db.type", (Object)"h2").put((Object)"metadata.db.filename", (Object)databaseDir.getAbsolutePath()).put((Object)"storage.data-directory", (Object)dataDir.getAbsolutePath()).put((Object)"storage.compress", (Object)"false").build();
            BlockEncodingSerde blockEncodingSerde = TestingBlockEncodingManager.createTestingBlockEncodingManager();
            TypeRegistry typeManager = new TypeRegistry();
            return new RaptorConnectorFactory((Map)config, nodeManager, blockEncodingSerde, (TypeManager)typeManager);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

