/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.benchmark.AbstractSqlBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.benchmark.SqlRewriteConditionalAggregationBenchmarks;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.intellij.lang.annotations.Language;

public class SqlRemoveRedundantDistinctAggregationBenchmarks
extends AbstractSqlBenchmark {
    private static final Logger LOGGER = Logger.get(SqlRewriteConditionalAggregationBenchmarks.class);

    public SqlRemoveRedundantDistinctAggregationBenchmarks(LocalQueryRunner localQueryRunner, @Language(value="SQL") String sql) {
        super(localQueryRunner, "remove_redundant_distinct_aggregation", 10, 20, sql);
    }

    public static void main(String[] args) {
        ImmutableMap disableOptimization = ImmutableMap.of((Object)"remove_redundant_distinct_aggregation_enabled", (Object)"false");
        String sql = "select distinct orderkey, partkey, suppkey, avg(extendedprice) from lineitem group by orderkey, partkey, suppkey";
        LOGGER.info("Without optimization");
        new SqlRemoveRedundantDistinctAggregationBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner((Map<String, String>)disableOptimization), sql).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
        LOGGER.info("With optimization");
        new SqlRemoveRedundantDistinctAggregationBenchmarks(BenchmarkQueryRunner.createLocalQueryRunner(), sql).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

