/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSimpleOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.testing.LocalQueryRunner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class CountAggregationBenchmark
extends AbstractSimpleOperatorBenchmark {
    public CountAggregationBenchmark(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "count_agg", 10, 100);
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "orders", "orderkey");
        FunctionManager functionManager = this.localQueryRunner.getMetadata().getFunctionManager();
        InternalAggregationFunction countFunction = functionManager.getAggregateFunctionImplementation(functionManager.lookupFunction("count", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        AggregationOperator.AggregationOperatorFactory aggregationOperator = new AggregationOperator.AggregationOperatorFactory(1, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)countFunction.bind((List)ImmutableList.of((Object)0), Optional.empty())), false);
        return ImmutableList.of((Object)tableScanOperator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new CountAggregationBenchmark(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }
}

