/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.BenchmarkResultHook;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class AverageBenchmarkResults
implements BenchmarkResultHook {
    private final Map<String, Long> resultsSum = new LinkedHashMap<String, Long>();
    private int resultsCount;

    @Override
    public BenchmarkResultHook addResults(Map<String, Long> results) {
        Objects.requireNonNull(results, "results is null");
        for (Map.Entry<String, Long> entry : results.entrySet()) {
            Long currentSum = this.resultsSum.get(entry.getKey());
            if (currentSum == null) {
                currentSum = 0L;
            }
            this.resultsSum.put(entry.getKey(), currentSum + entry.getValue());
        }
        ++this.resultsCount;
        return this;
    }

    public Map<String, Double> getAverageResultsValues() {
        return Maps.transformValues(this.resultsSum, input -> 1.0 * (double)input.longValue() / (double)this.resultsCount);
    }

    public Map<String, String> getAverageResultsStrings() {
        return Maps.transformValues(this.resultsSum, input -> String.format("%,3.2f", 1.0 * (double)input.longValue() / (double)this.resultsCount));
    }

    @Override
    public void finished() {
    }
}

