/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.presto.benchmark.AbstractSimpleOperatorBenchmark;
import com.facebook.presto.benchmark.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.SimpleLineBenchmarkResultWriter;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class HandTpchQuery6
extends AbstractSimpleOperatorBenchmark {
    private final InternalAggregationFunction doubleSum;

    public HandTpchQuery6(LocalQueryRunner localQueryRunner) {
        super(localQueryRunner, "hand_tpch_query_6", 10, 100);
        this.doubleSum = localQueryRunner.getMetadata().getFunctionRegistry().getAggregateFunctionImplementation(new Signature("sum", FunctionKind.AGGREGATE, DoubleType.DOUBLE.getTypeSignature(), new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature()}));
    }

    @Override
    protected List<? extends OperatorFactory> createOperatorFactories() {
        OperatorFactory tableScanOperator = this.createTableScanOperator(0, new PlanNodeId("test"), "lineitem", "extendedprice", "discount", "shipdate", "quantity");
        FilterAndProjectOperator.FilterAndProjectOperatorFactory tpchQuery6Operator = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(1, new PlanNodeId("test"), () -> new TpchQuery6Processor(), (List)ImmutableList.of((Object)DoubleType.DOUBLE));
        AggregationOperator.AggregationOperatorFactory aggregationOperator = new AggregationOperator.AggregationOperatorFactory(2, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)this.doubleSum.bind((List)ImmutableList.of((Object)0), Optional.empty(), Optional.empty(), 1.0)));
        return ImmutableList.of((Object)tableScanOperator, (Object)tpchQuery6Operator, (Object)aggregationOperator);
    }

    public static void main(String[] args) {
        new HandTpchQuery6(BenchmarkQueryRunner.createLocalQueryRunner()).runBenchmark(new SimpleLineBenchmarkResultWriter(System.out));
    }

    public static class TpchQuery6Processor
    implements PageProcessor {
        private static final int MIN_SHIP_DATE = DateTimeUtils.parseDate((String)"1994-01-01");
        private static final int MAX_SHIP_DATE = DateTimeUtils.parseDate((String)"1995-01-01");

        public int process(ConnectorSession session, Page page, int start, int end, PageBuilder pageBuilder) {
            int position;
            Block discountBlock = page.getBlock(1);
            for (position = start; position < end; ++position) {
                if (!TpchQuery6Processor.filter(position, discountBlock, page.getBlock(2), page.getBlock(3))) continue;
                TpchQuery6Processor.project(position, pageBuilder, page.getBlock(0), discountBlock);
            }
            return position;
        }

        public Page processColumnar(ConnectorSession session, Page page, List<? extends Type> types) {
            throw new UnsupportedOperationException();
        }

        public Page processColumnarDictionary(ConnectorSession session, Page page, List<? extends Type> types) {
            throw new UnsupportedOperationException();
        }

        private static void project(int position, PageBuilder pageBuilder, Block extendedPriceBlock, Block discountBlock) {
            if (discountBlock.isNull(position) || extendedPriceBlock.isNull(position)) {
                pageBuilder.getBlockBuilder(0).appendNull();
            } else {
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), DoubleType.DOUBLE.getDouble(extendedPriceBlock, position) * DoubleType.DOUBLE.getDouble(discountBlock, position));
            }
        }

        private static boolean filter(int position, Block discountBlock, Block shipDateBlock, Block quantityBlock) {
            return !shipDateBlock.isNull(position) && DateType.DATE.getLong(shipDateBlock, position) >= (long)MIN_SHIP_DATE && !shipDateBlock.isNull(position) && DateType.DATE.getLong(shipDateBlock, position) < (long)MAX_SHIP_DATE && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) >= 0.05 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) <= 0.07 && !quantityBlock.isNull(position) && BigintType.BIGINT.getLong(quantityBlock, position) < 24L;
        }
    }
}

