/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;

final class FormatUtils {
    private FormatUtils() {
    }

    public static String formatCount(long count) {
        double fractional = count;
        String unit = "";
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "K";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "M";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "B";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "T";
        }
        if (fractional > 1000.0) {
            fractional /= 1000.0;
            unit = "Q";
        }
        return String.format("%s%s", FormatUtils.getFormat(fractional).format(fractional), unit);
    }

    public static String formatCountRate(double count, Duration duration, boolean longForm) {
        double rate = count / duration.getValue(TimeUnit.SECONDS);
        if (Double.isNaN(rate) || Double.isInfinite(rate)) {
            rate = 0.0;
        }
        String rateString = FormatUtils.formatCount((long)rate);
        if (longForm) {
            if (rateString.endsWith(" ")) {
                rateString = rateString.substring(0, rateString.length() - 1);
            }
            rateString = rateString + "/s";
        }
        return rateString;
    }

    public static String formatDataSize(DataSize size, boolean longForm) {
        double fractional = size.toBytes();
        String unit = null;
        if (fractional >= 1024.0) {
            fractional /= 1024.0;
            unit = "K";
        }
        if (fractional >= 1024.0) {
            fractional /= 1024.0;
            unit = "M";
        }
        if (fractional >= 1024.0) {
            fractional /= 1024.0;
            unit = "G";
        }
        if (fractional >= 1024.0) {
            fractional /= 1024.0;
            unit = "T";
        }
        if (fractional >= 1024.0) {
            fractional /= 1024.0;
            unit = "P";
        }
        if (unit == null) {
            unit = "B";
        } else if (longForm) {
            unit = unit + "B";
        }
        return String.format("%s%s", FormatUtils.getFormat(fractional).format(fractional), unit);
    }

    public static String formatDataRate(DataSize dataSize, Duration duration, boolean longForm) {
        double rate = (double)dataSize.toBytes() / duration.getValue(TimeUnit.SECONDS);
        if (Double.isNaN(rate) || Double.isInfinite(rate)) {
            rate = 0.0;
        }
        String rateString = FormatUtils.formatDataSize(new DataSize(rate, DataSize.Unit.BYTE), false);
        if (longForm) {
            if (!rateString.endsWith("B")) {
                rateString = rateString + "B";
            }
            rateString = rateString + "/s";
        }
        return rateString;
    }

    public static DecimalFormat getFormat(double value) {
        DecimalFormat format = value < 10.0 ? new DecimalFormat("#.##") : (value < 100.0 ? new DecimalFormat("#.#") : new DecimalFormat("#"));
        format.setRoundingMode(RoundingMode.HALF_UP);
        return format;
    }
}

