/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.presto.benchmark.framework.ExecutionStrategy;
import com.facebook.presto.benchmark.framework.PhaseSpecification;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class StreamExecutionPhase
extends PhaseSpecification {
    private final List<List<String>> streams;

    @JsonCreator
    public StreamExecutionPhase(String name, List<List<String>> streams) {
        super(name);
        this.streams = (List)streams.stream().map(ImmutableList::copyOf).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ExecutionStrategy getExecutionStrategy() {
        return ExecutionStrategy.STREAM;
    }

    @JsonProperty
    public List<List<String>> getStreams() {
        return this.streams;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StreamExecutionPhase o = (StreamExecutionPhase)obj;
        return Objects.equals(this.getName(), o.getName()) && Objects.equals(this.streams, o.streams);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.streams);
    }
}

