/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.airlift.event.client.EventClient;
import com.facebook.presto.benchmark.event.BenchmarkPhaseEvent;
import com.facebook.presto.benchmark.event.BenchmarkSuiteEvent;
import com.facebook.presto.benchmark.framework.BenchmarkRunnerConfig;
import com.facebook.presto.benchmark.framework.BenchmarkSuite;
import com.facebook.presto.benchmark.framework.ConcurrentPhaseExecutor;
import com.facebook.presto.benchmark.framework.ExecutionStrategy;
import com.facebook.presto.benchmark.framework.PhaseExecutor;
import com.facebook.presto.benchmark.framework.PhaseSpecification;
import com.facebook.presto.benchmark.source.BenchmarkSuiteSupplier;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;

public class BenchmarkRunner {
    private final BenchmarkSuiteSupplier benchmarkSuiteSupplier;
    private final ConcurrentPhaseExecutor concurrentPhaseExecutor;
    private final Set<EventClient> eventClients;
    private final boolean continueOnFailure;

    @Inject
    public BenchmarkRunner(BenchmarkSuiteSupplier benchmarkSuiteSupplier, ConcurrentPhaseExecutor concurrentPhaseExecutor, Set<EventClient> eventClients, BenchmarkRunnerConfig config) {
        this.benchmarkSuiteSupplier = Objects.requireNonNull(benchmarkSuiteSupplier, "benchmarkSuiteSupplier is null");
        this.concurrentPhaseExecutor = Objects.requireNonNull(concurrentPhaseExecutor, "concurrentPhaseExecutor is null");
        this.eventClients = ImmutableSet.copyOf((Collection)Objects.requireNonNull(eventClients, "eventClients is null"));
        this.continueOnFailure = config.isContinueOnFailure();
    }

    @PostConstruct
    public void start() {
        BenchmarkSuiteEvent suiteEvent = this.runSuite((BenchmarkSuite)this.benchmarkSuiteSupplier.get());
        this.eventClients.forEach(client -> client.post((Object[])new BenchmarkSuiteEvent[]{suiteEvent}));
    }

    private BenchmarkSuiteEvent runSuite(BenchmarkSuite suite) {
        int successfulPhases = 0;
        for (PhaseSpecification phase : suite.getPhases()) {
            BenchmarkPhaseEvent phaseEvent = this.getPhaseExecutor(phase).runPhase(phase, suite);
            this.eventClients.forEach(client -> client.post((Object[])new BenchmarkPhaseEvent[]{phaseEvent}));
            if (phaseEvent.getEventStatus() == BenchmarkPhaseEvent.Status.SUCCEEDED) {
                ++successfulPhases;
                continue;
            }
            if (phaseEvent.getEventStatus() != BenchmarkPhaseEvent.Status.FAILED || this.continueOnFailure) continue;
            return BenchmarkSuiteEvent.failed(suite.getSuite());
        }
        if (successfulPhases < suite.getPhases().size()) {
            return BenchmarkSuiteEvent.completedWithFailures(suite.getSuite());
        }
        return BenchmarkSuiteEvent.succeeded(suite.getSuite());
    }

    private <T extends PhaseSpecification> PhaseExecutor<T> getPhaseExecutor(T phase) {
        if (phase.getExecutionStrategy() == ExecutionStrategy.CONCURRENT) {
            return this.concurrentPhaseExecutor;
        }
        throw new IllegalArgumentException(String.format("Unsupported execution strategy: %s", new Object[]{phase.getExecutionStrategy()}));
    }
}

