/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.presto.benchmark.framework.BenchmarkQuery;
import com.facebook.presto.benchmark.framework.PhaseSpecification;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;

public class BenchmarkSuite {
    private final String suite;
    private final String querySet;
    private final List<PhaseSpecification> phases;
    private final Map<String, String> sessionProperties;
    private final Map<String, BenchmarkQuery> queries;

    public BenchmarkSuite(String suite, String querySet, List<PhaseSpecification> phases, Map<String, String> sessionProperties, List<BenchmarkQuery> queries) {
        this.suite = Objects.requireNonNull(suite, "suite is null");
        this.querySet = Objects.requireNonNull(querySet, "querySet is null");
        this.phases = Objects.requireNonNull(phases, "phases is null");
        this.sessionProperties = ImmutableMap.copyOf(sessionProperties);
        this.queries = (Map)queries.stream().collect(ImmutableMap.toImmutableMap(BenchmarkQuery::getName, UnaryOperator.identity()));
    }

    public String getSuite() {
        return this.suite;
    }

    public String getQuerySet() {
        return this.querySet;
    }

    public List<PhaseSpecification> getPhases() {
        return this.phases;
    }

    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    public Map<String, BenchmarkQuery> getQueries() {
        return this.queries;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BenchmarkSuite o = (BenchmarkSuite)obj;
        return Objects.equals(this.suite, o.suite) && Objects.equals(this.querySet, o.querySet) && Objects.equals(this.phases, o.phases) && Objects.equals(this.sessionProperties, o.sessionProperties) && Objects.equals(this.queries, o.queries);
    }

    public int hashCode() {
        return Objects.hash(this.suite, this.querySet, this.phases, this.sessionProperties, this.queries);
    }

    public static class JdbiBuilder {
        private final String suite;
        private final String querySet;
        private final List<PhaseSpecification> phases;
        private final Map<String, String> sessionProperties;
        private List<BenchmarkQuery> queries;

        @JdbiConstructor
        public JdbiBuilder(@ColumnName(value="suite") String suite, @ColumnName(value="query_set") String querySet, @ColumnName(value="phases") List<PhaseSpecification> phases, @ColumnName(value="session_properties") Optional<Map<String, String>> sessionProperties) {
            this.suite = Objects.requireNonNull(suite, "suite is null");
            this.querySet = Objects.requireNonNull(querySet, "querySet is null");
            this.phases = Objects.requireNonNull(phases, "phases is null");
            this.sessionProperties = sessionProperties.orElse((Map<String, String>)ImmutableMap.of());
        }

        public String getQuerySet() {
            return this.querySet;
        }

        public JdbiBuilder setQueries(List<BenchmarkQuery> queries) {
            this.queries = ImmutableList.copyOf(queries);
            return this;
        }

        public BenchmarkSuite build() {
            return new BenchmarkSuite(this.suite, this.querySet, this.phases, this.sessionProperties, this.queries);
        }
    }
}

