/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import java.util.Objects;
import java.util.Optional;

public class QueryException
extends RuntimeException {
    private final Type type;
    private final Optional<ErrorCodeSupplier> prestoErrorCode;
    private final Optional<QueryStats> queryStats;

    public QueryException(Throwable cause, Type type, Optional<ErrorCodeSupplier> prestoErrorCode, Optional<QueryStats> queryStats) {
        super(cause);
        this.type = Objects.requireNonNull(type, "type is null");
        this.prestoErrorCode = Objects.requireNonNull(prestoErrorCode, "errorCode is null");
        this.queryStats = Objects.requireNonNull(queryStats, "queryStats is null");
    }

    public static QueryException forClusterConnection(Throwable cause) {
        return new QueryException(cause, Type.CLUSTER_CONNECTION, Optional.empty(), Optional.empty());
    }

    public static QueryException forPresto(Throwable cause, Optional<ErrorCodeSupplier> prestoErrorCode, Optional<QueryStats> queryStats) {
        return new QueryException(cause, Type.PRESTO, prestoErrorCode, queryStats);
    }

    public Type getType() {
        return this.type;
    }

    public Optional<ErrorCodeSupplier> getPrestoErrorCode() {
        return this.prestoErrorCode;
    }

    public Optional<QueryStats> getQueryStats() {
        return this.queryStats;
    }

    public static enum Type {
        CLUSTER_CONNECTION,
        PRESTO;

    }
}

