/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.event;

import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventType;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@EventType(value="BenchmarkSuite")
@Immutable
public class BenchmarkSuiteEvent {
    private final String name;
    private final String status;

    public BenchmarkSuiteEvent(String name, Status status) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.status = Objects.requireNonNull(status, "status is null").name();
    }

    public static BenchmarkSuiteEvent succeeded(String name) {
        return new BenchmarkSuiteEvent(name, Status.SUCCEEDED);
    }

    public static BenchmarkSuiteEvent failed(String name) {
        return new BenchmarkSuiteEvent(name, Status.FAILED);
    }

    public static BenchmarkSuiteEvent completedWithFailures(String name) {
        return new BenchmarkSuiteEvent(name, Status.COMPLETED_WITH_FAILURES);
    }

    @EventField
    public String getName() {
        return this.name;
    }

    @EventField
    public String getStatus() {
        return this.status;
    }

    public static enum Status {
        SUCCEEDED,
        COMPLETED_WITH_FAILURES,
        FAILED;

    }
}

