/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.source;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.benchmark.framework.BenchmarkRunnerConfig;
import com.facebook.presto.benchmark.source.BenchmarkSuiteConfig;
import com.facebook.presto.benchmark.source.BenchmarkSuiteSupplier;
import com.facebook.presto.benchmark.source.MySqlBenchmarkSuiteConfig;
import com.facebook.presto.benchmark.source.MySqlBenchmarkSuiteSupplier;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import java.util.Set;

public class BenchmarkSuiteModule
extends AbstractConfigurationAwareModule {
    private final Set<String> supportedBenchmarkSuiteSuppliers;

    public BenchmarkSuiteModule(Set<String> customBenchmarkSuiteSuppliers) {
        this.supportedBenchmarkSuiteSuppliers = ImmutableSet.builder().add((Object)"mysql").addAll(customBenchmarkSuiteSuppliers).build();
    }

    protected void setup(Binder binder) {
        String benchmarkSuiteSupplier = ((BenchmarkRunnerConfig)this.buildConfigObject(BenchmarkRunnerConfig.class)).getBenchmarkSuiteSupplier();
        Preconditions.checkArgument((boolean)this.supportedBenchmarkSuiteSuppliers.contains(benchmarkSuiteSupplier), (String)"Unsupported BenchmarkSuiteSupplier: %s", (Object)benchmarkSuiteSupplier);
        if ("mysql".equals(benchmarkSuiteSupplier)) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(BenchmarkSuiteConfig.class, "benchmark-suite");
            ConfigBinder.configBinder((Binder)binder).bindConfig(MySqlBenchmarkSuiteConfig.class, "benchmark-suite");
            binder.bind(BenchmarkSuiteSupplier.class).to(MySqlBenchmarkSuiteSupplier.class).in(Scopes.SINGLETON);
        }
    }
}

