/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.source;

import com.facebook.presto.benchmark.framework.BenchmarkSuite;
import com.facebook.presto.benchmark.source.BenchmarkSuiteConfig;
import com.facebook.presto.benchmark.source.BenchmarkSuiteDao;
import com.facebook.presto.benchmark.source.BenchmarkSuiteSupplier;
import java.util.Objects;
import org.jdbi.v3.core.Jdbi;

public abstract class AbstractJdbiBenchmarkSuiteSupplier
implements BenchmarkSuiteSupplier {
    private final Jdbi jdbi;
    private final String suitesTableName;
    private final String queriesTableName;
    private final String suite;

    public AbstractJdbiBenchmarkSuiteSupplier(Jdbi jdbi, BenchmarkSuiteConfig config) {
        this.jdbi = Objects.requireNonNull(jdbi, "jdbi is null");
        this.suitesTableName = Objects.requireNonNull(config.getSuitesTableName(), "suitesTableName is null");
        this.queriesTableName = Objects.requireNonNull(config.getQueriesTableName(), "queriesTableName is null");
        this.suite = Objects.requireNonNull(config.getSuite(), "suite is null");
    }

    @Override
    public BenchmarkSuite get() {
        return (BenchmarkSuite)this.jdbi.inTransaction(handle -> {
            BenchmarkSuiteDao dao = (BenchmarkSuiteDao)handle.attach(BenchmarkSuiteDao.class);
            BenchmarkSuite.JdbiBuilder suiteBuilder = dao.getBenchmarkSuite(this.suitesTableName, this.suite);
            return suiteBuilder.setQueries(dao.getBenchmarkQueries(this.queriesTableName, suiteBuilder.getQuerySet())).build();
        });
    }
}

