/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.presto.benchmark.framework.ExecutionStrategy;
import com.facebook.presto.benchmark.framework.PhaseSpecification;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ConcurrentExecutionPhase
extends PhaseSpecification {
    private final List<String> queries;
    private Optional<Integer> maxConcurrency;

    @JsonCreator
    public ConcurrentExecutionPhase(String name, List<String> queries, Optional<Integer> maxConcurrency) {
        super(name);
        this.queries = ImmutableList.copyOf(queries);
        this.maxConcurrency = Objects.requireNonNull(maxConcurrency, "maxConcurrency is null");
    }

    @Override
    public ExecutionStrategy getExecutionStrategy() {
        return ExecutionStrategy.CONCURRENT;
    }

    @JsonProperty
    public List<String> getQueries() {
        return this.queries;
    }

    @JsonProperty
    public Optional<Integer> getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConcurrentExecutionPhase o = (ConcurrentExecutionPhase)obj;
        return Objects.equals(this.getName(), o.getName()) && Objects.equals(this.queries, o.queries) && Objects.equals(this.maxConcurrency, o.maxConcurrency);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.queries, this.maxConcurrency);
    }
}

