/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.retry;

import com.facebook.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;

public class RetryConfig {
    private int maxAttempts = 1;
    private Duration minBackoffDelay = new Duration(0.0, TimeUnit.NANOSECONDS);
    private Duration maxBackoffDelay = new Duration(1.0, TimeUnit.MINUTES);
    private double scaleFactor = 1.0;

    @Min(value=1L)
    public @Min(value=1L) int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Config(value="max-attempts")
    public RetryConfig setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    @MinDuration(value="0ns")
    public Duration getMinBackoffDelay() {
        return this.minBackoffDelay;
    }

    @Config(value="min-backoff-delay")
    public RetryConfig setMinBackoffDelay(Duration minBackoffDelay) {
        this.minBackoffDelay = minBackoffDelay;
        return this;
    }

    @MinDuration(value="0ns")
    public Duration getMaxBackoffDelay() {
        return this.maxBackoffDelay;
    }

    @Config(value="max-backoff-delay")
    public RetryConfig setMaxBackoffDelay(Duration maxBackoffDelay) {
        this.maxBackoffDelay = maxBackoffDelay;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) double getScaleFactor() {
        return this.scaleFactor;
    }

    @Config(value="backoff-scale-factor")
    public RetryConfig setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
        return this;
    }
}

