/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.presto.benchmark.framework.PhaseSpecification;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class ConcurrentExecutionPhase
extends PhaseSpecification {
    private final PhaseSpecification.ExecutionStrategy executionStrategy;
    private final List<String> queries;
    private int maxConcurrency = 50;

    @JsonCreator
    public ConcurrentExecutionPhase(String name, PhaseSpecification.ExecutionStrategy executionStrategy, List<String> queries, int maxConcurrency) {
        super(name);
        this.executionStrategy = Objects.requireNonNull(executionStrategy, "executionStrategy is null");
        this.queries = (List)Objects.requireNonNull(ImmutableList.copyOf(queries), "queries is null");
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    @JsonProperty
    public PhaseSpecification.ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    @JsonProperty
    public List<String> getQueries() {
        return this.queries;
    }

    @JsonProperty
    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConcurrentExecutionPhase o = (ConcurrentExecutionPhase)obj;
        return Objects.equals((Object)this.getExecutionStrategy(), (Object)o.getExecutionStrategy()) && Objects.equals(this.getName(), o.getName()) && Objects.equals(this.queries, o.queries);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getExecutionStrategy(), this.getName(), this.queries});
    }
}

