/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.presto.benchmark.framework.BenchmarkQuery;
import com.facebook.presto.benchmark.framework.BenchmarkSuiteInfo;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;

public class BenchmarkSuite {
    private final String name;
    private final BenchmarkSuiteInfo suiteInfo;
    private final Map<String, BenchmarkQuery> queries;

    public BenchmarkSuite(String name, BenchmarkSuiteInfo suiteInfo, List<BenchmarkQuery> queries) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.suiteInfo = Objects.requireNonNull(suiteInfo, "SuiteInfo is null");
        this.queries = (Map)queries.stream().collect(ImmutableMap.toImmutableMap(BenchmarkQuery::getName, UnaryOperator.identity()));
    }

    public String getName() {
        return this.name;
    }

    public BenchmarkSuiteInfo getSuiteInfo() {
        return this.suiteInfo;
    }

    public Map<String, BenchmarkQuery> getQueryMap() {
        return this.queries;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BenchmarkSuite o = (BenchmarkSuite)obj;
        return Objects.equals(this.suiteInfo, o.suiteInfo) && Objects.equals(this.queries, o.queries);
    }

    public int hashCode() {
        return Objects.hash(this.suiteInfo, this.queries);
    }
}

