/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotNull;

public class BenchmarkRunnerConfig {
    private String testId;
    private String benchmarkSuiteSupplier = "mysql";
    private Set<String> eventClients = ImmutableSet.of((Object)"json");
    private Optional<String> jsonEventLogFile = Optional.empty();
    private boolean continueOnFailure;

    @NotNull
    public String getTestId() {
        return this.testId;
    }

    @Config(value="test-id")
    public BenchmarkRunnerConfig setTestId(String testId) {
        this.testId = testId;
        return this;
    }

    @NotNull
    public String getBenchmarkSuiteSupplier() {
        return this.benchmarkSuiteSupplier;
    }

    @Config(value="benchmark-suite-supplier")
    public BenchmarkRunnerConfig setBenchmarkSuiteSupplier(String benchmarkSuiteSupplier) {
        this.benchmarkSuiteSupplier = benchmarkSuiteSupplier;
        return this;
    }

    @NotNull
    public Set<String> getEventClients() {
        return this.eventClients;
    }

    @ConfigDescription(value="The event client(s) to log the results to")
    @Config(value="event-clients")
    public BenchmarkRunnerConfig setEventClients(String eventClients) {
        this.eventClients = ImmutableSet.copyOf((Collection)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)eventClients));
        return this;
    }

    @NotNull
    public Optional<String> getJsonEventLogFile() {
        return this.jsonEventLogFile;
    }

    @ConfigDescription(value="The file to log json events. Used with event-clients=json. Print to standard output stream if not specified.")
    @Config(value="json.log-file")
    public BenchmarkRunnerConfig setJsonEventLogFile(String jsonEventLogFile) {
        this.jsonEventLogFile = Optional.ofNullable(jsonEventLogFile);
        return this;
    }

    public boolean isContinueOnFailure() {
        return this.continueOnFailure;
    }

    @Config(value="continue-on-failure")
    public BenchmarkRunnerConfig setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
        return this;
    }
}

