/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.bootstrap.LifeCycleManager;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.benchmark.event.EventClientModule;
import com.facebook.presto.benchmark.framework.BenchmarkModule;
import com.facebook.presto.benchmark.prestoaction.PrestoExceptionClassifier;
import com.facebook.presto.benchmark.source.BenchmarkSuiteModule;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import io.airlift.airline.Command;
import java.util.Set;

@Command(name="benchmark", description="benchmark")
public class PrestoBenchmarkCommand
implements Runnable {
    private static final Logger log = Logger.get(PrestoBenchmarkCommand.class);

    @Override
    public void run() {
        Bootstrap app = new Bootstrap((Iterable)ImmutableList.builder().add((Object)new BenchmarkSuiteModule((Set<String>)ImmutableSet.of())).add((Object)new BenchmarkModule(new SqlParserOptions(), ParsingOptions.builder().setDecimalLiteralTreatment(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE).build(), new PrestoExceptionClassifier((Set<ErrorCodeSupplier>)ImmutableSet.of()))).add((Object)new EventClientModule((Set<String>)ImmutableSet.of())).build());
        Injector injector = null;
        try {
            injector = app.strictConfig().initialize();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (injector != null) {
                try {
                    ((LifeCycleManager)injector.getInstance(LifeCycleManager.class)).stop();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
    }
}

