/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.event;

import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@EventType(value="BenchmarkPhase")
@Immutable
public class BenchmarkPhaseEvent {
    private final String name;
    private final String status;
    private final String errorMessage;

    public BenchmarkPhaseEvent(String name, Status status, Optional<String> errorMessage) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.status = Objects.requireNonNull(status, "status is null").name();
        this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage is null").orElse(null);
    }

    public static BenchmarkPhaseEvent succeeded(String name) {
        return new BenchmarkPhaseEvent(name, Status.SUCCEEDED, Optional.empty());
    }

    public static BenchmarkPhaseEvent failed(String name, String errorMessage) {
        return new BenchmarkPhaseEvent(name, Status.FAILED, Optional.of(errorMessage));
    }

    public static BenchmarkPhaseEvent completedWithFailures(String name, String errorMessage) {
        return new BenchmarkPhaseEvent(name, Status.COMPLETED_WITH_FAILURES, Optional.of(errorMessage));
    }

    @EventField
    public String getName() {
        return this.name;
    }

    @EventField
    public String getStatus() {
        return this.status;
    }

    @EventField
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Status getEventStatus() {
        return Status.valueOf(this.status);
    }

    public static enum Status {
        SUCCEEDED,
        COMPLETED_WITH_FAILURES,
        FAILED;

    }
}

