/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.airlift.event.client.EventClient;
import com.facebook.presto.benchmark.event.BenchmarkPhaseEvent;
import com.facebook.presto.benchmark.event.BenchmarkSuiteEvent;
import com.facebook.presto.benchmark.executor.PhaseExecutor;
import com.facebook.presto.benchmark.executor.PhaseExecutorFactory;
import com.facebook.presto.benchmark.framework.BenchmarkRunnerConfig;
import com.facebook.presto.benchmark.framework.BenchmarkSuite;
import com.facebook.presto.benchmark.framework.BenchmarkSuiteInfo;
import com.facebook.presto.benchmark.framework.PhaseSpecification;
import com.facebook.presto.benchmark.source.BenchmarkSuiteSupplier;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;

public class BenchmarkRunner {
    private final BenchmarkSuiteSupplier benchmarkSuiteSupplier;
    private final PhaseExecutorFactory phaseExecutorFactory;
    private final Set<EventClient> eventClients;
    private final boolean continueOnFailure;

    @Inject
    public BenchmarkRunner(BenchmarkSuiteSupplier benchmarkSuiteSupplier, PhaseExecutorFactory phaseExecutorFactory, Set<EventClient> eventClients, BenchmarkRunnerConfig benchmarkRunnerConfig) {
        this.benchmarkSuiteSupplier = Objects.requireNonNull(benchmarkSuiteSupplier, "benchmarkSuiteSupplier is null");
        this.phaseExecutorFactory = Objects.requireNonNull(phaseExecutorFactory, "phaseExecutorFactory is null");
        this.eventClients = ImmutableSet.copyOf((Collection)Objects.requireNonNull(eventClients, "eventClients is null"));
        this.continueOnFailure = Objects.requireNonNull(benchmarkRunnerConfig, "benchmarkRunnerConfig is null").isContinueOnFailure();
    }

    @PostConstruct
    public void start() {
        BenchmarkSuite benchmarkSuite = (BenchmarkSuite)this.benchmarkSuiteSupplier.get();
        BenchmarkSuiteInfo benchmarkSuiteInfo = benchmarkSuite.getSuiteInfo();
        List<PhaseSpecification> phases = benchmarkSuiteInfo.getPhases();
        int successfulPhases = 0;
        for (PhaseSpecification phase : phases) {
            PhaseExecutor phaseExecutor = this.phaseExecutorFactory.get(phase, benchmarkSuite);
            BenchmarkPhaseEvent phaseEvent = phaseExecutor.run(this.continueOnFailure);
            if (phaseEvent.getEventStatus() == BenchmarkPhaseEvent.Status.SUCCEEDED) {
                ++successfulPhases;
                continue;
            }
            if (phaseEvent.getEventStatus() != BenchmarkPhaseEvent.Status.FAILED || this.continueOnFailure) continue;
            this.postEvent(BenchmarkSuiteEvent.failed(benchmarkSuite.getName()));
            break;
        }
        if (successfulPhases < phases.size()) {
            this.postEvent(BenchmarkSuiteEvent.completedWithFailures(benchmarkSuite.getName()));
        } else {
            this.postEvent(BenchmarkSuiteEvent.succeeded(benchmarkSuite.getName()));
        }
    }

    private void postEvent(BenchmarkSuiteEvent event) {
        for (EventClient eventClient : this.eventClients) {
            eventClient.post((Object[])new BenchmarkSuiteEvent[]{event});
        }
    }
}

