/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.benchmark.executor.BenchmarkQueryExecutor;
import com.facebook.presto.benchmark.executor.PhaseExecutorFactory;
import com.facebook.presto.benchmark.framework.BenchmarkRunner;
import com.facebook.presto.benchmark.framework.BenchmarkRunnerConfig;
import com.facebook.presto.benchmark.prestoaction.BenchmarkPrestoActionFactory;
import com.facebook.presto.benchmark.prestoaction.PrestoActionFactory;
import com.facebook.presto.benchmark.prestoaction.PrestoClusterConfig;
import com.facebook.presto.benchmark.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.benchmark.retry.RetryConfig;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import java.util.Objects;

public class BenchmarkModule
extends AbstractConfigurationAwareModule {
    private final SqlParserOptions sqlParserOptions;
    private final ParsingOptions parsingOptions;
    private final SqlExceptionClassifier exceptionClassifier;

    public BenchmarkModule(SqlParserOptions sqlParserOptions, ParsingOptions parsingOptions, SqlExceptionClassifier exceptionClassifier) {
        this.sqlParserOptions = Objects.requireNonNull(sqlParserOptions, "sqlParserOptions is null");
        this.parsingOptions = Objects.requireNonNull(parsingOptions, "parsingOptions is null");
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
    }

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(BenchmarkRunnerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(PrestoClusterConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(RetryConfig.class);
        binder.bind(SqlExceptionClassifier.class).toInstance((Object)this.exceptionClassifier);
        binder.bind(SqlParserOptions.class).toInstance((Object)this.sqlParserOptions);
        binder.bind(ParsingOptions.class).toInstance((Object)this.parsingOptions);
        binder.bind(SqlParser.class).in(Scopes.SINGLETON);
        binder.bind(PrestoActionFactory.class).to(BenchmarkPrestoActionFactory.class).in(Scopes.SINGLETON);
        binder.bind(PhaseExecutorFactory.class).in(Scopes.SINGLETON);
        binder.bind(BenchmarkQueryExecutor.class).in(Scopes.SINGLETON);
        binder.bind(BenchmarkRunner.class).in(Scopes.SINGLETON);
    }
}

