/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.executor;

import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.benchmark.event.BenchmarkPhaseEvent;
import com.facebook.presto.benchmark.event.BenchmarkQueryEvent;
import com.facebook.presto.benchmark.executor.PhaseExecutor;
import com.facebook.presto.benchmark.executor.QueryExecutor;
import com.facebook.presto.benchmark.framework.BenchmarkQuery;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ConcurrentPhaseExecutor
implements PhaseExecutor {
    private static final Logger log = Logger.get(ConcurrentPhaseExecutor.class);
    private final String phaseName;
    private final QueryExecutor queryExecutor;
    private final List<BenchmarkQuery> queries;
    private final Set<EventClient> eventClients;
    private final Map<String, String> sessionProperties;
    private final int maxConcurrency;
    private ExecutorService executor;
    private CompletionService<BenchmarkQueryEvent> completionService;

    public ConcurrentPhaseExecutor(String phaseName, QueryExecutor queryExecutor, List<BenchmarkQuery> queries, Set<EventClient> eventClients, Map<String, String> sessionProperties, int maxConcurrency) {
        this.phaseName = Objects.requireNonNull(phaseName, "phaseName is null");
        this.queryExecutor = Objects.requireNonNull(queryExecutor, "benchmarkQueryExecutor is null");
        this.queries = ImmutableList.copyOf((Collection)Objects.requireNonNull(queries, "queries is null"));
        this.eventClients = Objects.requireNonNull(eventClients, "eventClients is null");
        this.sessionProperties = ImmutableMap.copyOf(Objects.requireNonNull(sessionProperties, "sessionProperties is null"));
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    public BenchmarkPhaseEvent run(boolean continueOnFailure) {
        this.executor = Executors.newFixedThreadPool(this.maxConcurrency);
        this.completionService = new ExecutorCompletionService<BenchmarkQueryEvent>(this.executor);
        for (BenchmarkQuery query : this.queries) {
            this.completionService.submit(() -> this.queryExecutor.run(query, this.sessionProperties));
        }
        return this.reportProgressUntilFinished(this.queries.size(), continueOnFailure);
    }

    private BenchmarkPhaseEvent reportProgressUntilFinished(int queriesSubmitted, boolean continueOnFailure) {
        int completed = 0;
        double lastProgress = 0.0;
        EnumMap<BenchmarkQueryEvent.Status, Integer> statusCount = new EnumMap<BenchmarkQueryEvent.Status, Integer>(BenchmarkQueryEvent.Status.class);
        while (completed < queriesSubmitted) {
            try {
                BenchmarkQueryEvent event = this.completionService.take().get();
                ++completed;
                statusCount.compute(event.getEventStatus(), (status, count) -> count == null ? 1 : count + 1);
                if (event.getEventStatus() == BenchmarkQueryEvent.Status.FAILED && !continueOnFailure) {
                    this.executor.shutdownNow();
                    return this.postEvent(BenchmarkPhaseEvent.failed(this.phaseName, event.getErrorMessage()));
                }
                double progress = (double)completed / (double)queriesSubmitted * 100.0;
                if (!(progress - lastProgress > 0.5) && completed != queriesSubmitted) continue;
                log.info("Progress: %s succeeded, %s failed, %s submitted, %.2f%% done", new Object[]{statusCount.getOrDefault((Object)BenchmarkQueryEvent.Status.SUCCEEDED, 0), statusCount.getOrDefault((Object)BenchmarkQueryEvent.Status.FAILED, 0), queriesSubmitted, progress});
                lastProgress = progress;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (continueOnFailure) continue;
                this.executor.shutdownNow();
                return this.postEvent(BenchmarkPhaseEvent.failed(this.phaseName, e.toString()));
            }
            catch (ExecutionException e) {
                this.executor.shutdownNow();
                if (continueOnFailure) continue;
                this.executor.shutdownNow();
                return this.postEvent(BenchmarkPhaseEvent.failed(this.phaseName, e.toString()));
            }
        }
        if (statusCount.getOrDefault((Object)BenchmarkQueryEvent.Status.FAILED, 0) > 0) {
            return this.postEvent(BenchmarkPhaseEvent.completedWithFailures(this.phaseName, String.format("%s out of %s submitted queries failed", statusCount.get((Object)BenchmarkQueryEvent.Status.FAILED), queriesSubmitted)));
        }
        return this.postEvent(BenchmarkPhaseEvent.succeeded(this.phaseName));
    }

    private BenchmarkPhaseEvent postEvent(BenchmarkPhaseEvent event) {
        for (EventClient eventClient : this.eventClients) {
            eventClient.post((Object[])new BenchmarkPhaseEvent[]{event});
        }
        return event;
    }
}

