/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.event;

import com.facebook.airlift.event.client.EventField;
import com.facebook.airlift.event.client.EventType;
import com.facebook.presto.jdbc.QueryStats;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;

@EventType(value="BenchmarkQuery")
@Immutable
public class BenchmarkQueryEvent {
    private final String testId;
    private final String name;
    private final String status;
    private final String catalog;
    private final String schema;
    private final String query;
    private final String queryId;
    private final Double cpuTimeSecs;
    private final Double wallTimeSecs;
    private final String errorCode;
    private final String errorMessage;
    private final String stackTrace;

    public BenchmarkQueryEvent(String testId, String name, Status status, String catalog, String schema, String query, Optional<QueryStats> queryStats, Optional<String> errorCode, Optional<String> errorMessage, Optional<String> stackTrace) {
        this.testId = Objects.requireNonNull(testId, "testId is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.status = Objects.requireNonNull(status, "status is null").name();
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.queryId = Objects.requireNonNull(queryStats, "queryStats is null").map(QueryStats::getQueryId).orElse(null);
        this.cpuTimeSecs = BenchmarkQueryEvent.millisToSeconds(queryStats.map(QueryStats::getCpuTimeMillis)).orElse(null);
        this.wallTimeSecs = BenchmarkQueryEvent.millisToSeconds(queryStats.map(QueryStats::getWallTimeMillis)).orElse(null);
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null").orElse(null);
        this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage is null").orElse("");
        this.stackTrace = Objects.requireNonNull(stackTrace, "stackTrace is null").orElse(null);
    }

    @EventField
    public String getTestId() {
        return this.testId;
    }

    @EventField
    public String getName() {
        return this.name;
    }

    @EventField
    public String getStatus() {
        return this.status;
    }

    @EventField
    public String getCatalog() {
        return this.catalog;
    }

    @EventField
    public String getSchema() {
        return this.schema;
    }

    @EventField
    public String getQuery() {
        return this.query;
    }

    @EventField
    public String getQueryId() {
        return this.queryId;
    }

    @EventField
    public Double getCpuTime() {
        return this.cpuTimeSecs;
    }

    @EventField
    public Double getWallTime() {
        return this.wallTimeSecs;
    }

    @EventField
    public String getErrorCode() {
        return this.errorCode;
    }

    @EventField
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @EventField
    public String getStackTrace() {
        return this.stackTrace;
    }

    public Status getEventStatus() {
        return Status.valueOf(this.status);
    }

    private static Optional<Double> millisToSeconds(Optional<Long> millis) {
        return millis.map(value -> new Duration((double)value.longValue(), TimeUnit.MILLISECONDS).getValue(TimeUnit.SECONDS));
    }

    public static enum Status {
        SUCCEEDED,
        FAILED;

    }
}

