/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.prestoaction;

import com.facebook.presto.benchmark.framework.BenchmarkQuery;
import com.facebook.presto.benchmark.framework.QueryException;
import com.facebook.presto.benchmark.framework.QueryResult;
import com.facebook.presto.benchmark.prestoaction.PrestoAction;
import com.facebook.presto.benchmark.prestoaction.PrestoClusterConfig;
import com.facebook.presto.benchmark.prestoaction.SqlExceptionClassifier;
import com.facebook.presto.benchmark.retry.RetryConfig;
import com.facebook.presto.benchmark.retry.RetryDriver;
import com.facebook.presto.jdbc.PrestoConnection;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class JdbcPrestoAction
implements PrestoAction {
    private static final String QUERY_MAX_EXECUTION_TIME = "query_max_execution_time";
    private final SqlExceptionClassifier exceptionClassifier;
    private final BenchmarkQuery benchmarkQuery;
    private final String jdbcUrl;
    private final Duration queryTimeout;
    private final Map<String, String> sessionProperties;
    private final RetryDriver networkRetry;

    public JdbcPrestoAction(SqlExceptionClassifier exceptionClassifier, BenchmarkQuery benchmarkQuery, PrestoClusterConfig prestoClusterConfig, Map<String, String> sessionProperties, RetryConfig networkRetryConfig) {
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.benchmarkQuery = Objects.requireNonNull(benchmarkQuery, "benchmarkQuery is null");
        this.jdbcUrl = Objects.requireNonNull(prestoClusterConfig.getJdbcUrl(), "jdbcUrl is null");
        this.queryTimeout = Objects.requireNonNull(prestoClusterConfig.getQueryTimeout(), "queryTimeout is null");
        this.sessionProperties = ImmutableMap.copyOf(sessionProperties);
        this.networkRetry = new RetryDriver(networkRetryConfig, exception -> exception instanceof QueryException && ((QueryException)exception).getType() == QueryException.Type.CLUSTER_CONNECTION);
    }

    @Override
    public QueryStats execute(Statement statement) {
        return this.execute(statement, Optional.empty()).getQueryStats();
    }

    @Override
    public <R> QueryResult<R> execute(Statement statement, PrestoAction.ResultSetConverter<R> converter) {
        return this.execute(statement, Optional.of(converter));
    }

    private <R> QueryResult<R> execute(Statement statement, Optional<PrestoAction.ResultSetConverter<R>> converter) {
        return this.networkRetry.run("presto-cluster-connection", () -> this.executeOnce(statement, converter));
    }

    /*
     * Exception decompiling
     */
    private <R> QueryResult<R> executeOnce(Statement statement, Optional<PrestoAction.ResultSetConverter<R>> converter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void consumeResultSet(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
        }
    }

    private PrestoConnection getConnection() throws SQLException {
        PrestoConnection connection = DriverManager.getConnection(this.jdbcUrl, "user", null).unwrap(PrestoConnection.class);
        try {
            connection.setClientInfo("ApplicationName", "benchmark-test");
            connection.setCatalog(this.benchmarkQuery.getCatalog());
            connection.setSchema(this.benchmarkQuery.getSchema());
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            // empty catch block
        }
        ImmutableMap sessionProperties = ImmutableMap.builder().putAll(this.sessionProperties).put((Object)QUERY_MAX_EXECUTION_TIME, (Object)this.queryTimeout.toString()).build();
        for (Map.Entry entry : sessionProperties.entrySet()) {
            connection.setSessionProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return connection;
    }

    static class ProgressMonitor
    implements Consumer<QueryStats> {
        private Optional<QueryStats> queryStats = Optional.empty();

        ProgressMonitor() {
        }

        @Override
        public synchronized void accept(QueryStats queryStats) {
            this.queryStats = Optional.of(Objects.requireNonNull(queryStats, "queryStats is null"));
        }

        public synchronized Optional<QueryStats> getLastQueryStats() {
            return this.queryStats;
        }
    }
}

