/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import com.facebook.presto.benchmark.framework.PhaseSpecification;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;

public class BenchmarkSuiteInfo {
    private final String suite;
    private final String querySet;
    private final List<PhaseSpecification> phases;
    private final Map<String, String> sessionProperties;

    @JdbiConstructor
    public BenchmarkSuiteInfo(@ColumnName(value="suite") String suite, @ColumnName(value="query_set") String querySet, @ColumnName(value="phases") List<PhaseSpecification> phases, @ColumnName(value="session_properties") Map<String, String> sessionProperties) {
        this.suite = Objects.requireNonNull(suite, "suite is null");
        this.querySet = Objects.requireNonNull(querySet, "querySet is null");
        this.phases = Objects.requireNonNull(phases, "phases is null");
        this.sessionProperties = ImmutableMap.copyOf(sessionProperties);
    }

    public String getSuite() {
        return this.suite;
    }

    public String getQuerySet() {
        return this.querySet;
    }

    public List<PhaseSpecification> getPhases() {
        return this.phases;
    }

    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BenchmarkSuiteInfo o = (BenchmarkSuiteInfo)obj;
        return Objects.equals(this.suite, o.getSuite()) && Objects.equals(this.querySet, o.querySet) && Objects.equals(this.phases, o.phases) && Objects.equals(this.sessionProperties, o.sessionProperties);
    }

    public int hashCode() {
        return Objects.hash(this.suite, this.querySet, this.phases, this.sessionProperties);
    }
}

