/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.framework;

import java.util.Objects;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;

public class BenchmarkQuery {
    private final String name;
    private final String query;
    private final String catalog;
    private final String schema;

    @JdbiConstructor
    public BenchmarkQuery(@ColumnName(value="name") String name, @ColumnName(value="query") String query, @ColumnName(value="catalog") String catalog, @ColumnName(value="schema") String schema) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.query = BenchmarkQuery.clean(query);
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
    }

    public String getName() {
        return this.name;
    }

    public String getQuery() {
        return this.query;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BenchmarkQuery o = (BenchmarkQuery)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.catalog, o.catalog) && Objects.equals(this.schema, o.schema);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.query, this.catalog, this.schema);
    }

    private static String clean(String sql) {
        sql = sql.replaceAll("\t", "  ");
        sql = sql.replaceAll("\n+", "\n");
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        return sql;
    }
}

