/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.executor;

import com.facebook.airlift.event.client.EventClient;
import com.facebook.presto.benchmark.executor.BenchmarkQueryExecutor;
import com.facebook.presto.benchmark.executor.ConcurrentPhaseExecutor;
import com.facebook.presto.benchmark.executor.PhaseExecutor;
import com.facebook.presto.benchmark.framework.BenchmarkSuite;
import com.facebook.presto.benchmark.framework.ConcurrentExecutionPhase;
import com.facebook.presto.benchmark.framework.PhaseSpecification;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PhaseExecutorFactory {
    private BenchmarkQueryExecutor benchmarkQueryExecutor;
    private Set<EventClient> eventClients;

    @Inject
    public PhaseExecutorFactory(BenchmarkQueryExecutor benchmarkQueryExecutor, Set<EventClient> eventClients) {
        this.benchmarkQueryExecutor = Objects.requireNonNull(benchmarkQueryExecutor, "benchmarkQueryExecutor is null");
        this.eventClients = Objects.requireNonNull(eventClients, "eventClients is null");
    }

    public PhaseExecutor get(PhaseSpecification phaseSpecification, BenchmarkSuite benchmarkSuite) {
        PhaseSpecification.ExecutionStrategy executionStrategy = phaseSpecification.getExecutionStrategy();
        switch (executionStrategy) {
            case CONCURRENT: {
                ConcurrentExecutionPhase phase = (ConcurrentExecutionPhase)phaseSpecification;
                List queryList = (List)phase.getQueries().stream().map(query -> benchmarkSuite.getQueryMap().get(query)).collect(ImmutableList.toImmutableList());
                return new ConcurrentPhaseExecutor(phase.getName(), this.benchmarkQueryExecutor, queryList, this.eventClients, benchmarkSuite.getSuiteInfo().getSessionProperties(), phase.getMaxConcurrency());
            }
        }
        throw new IllegalStateException(String.format("Unsupported execution strategy type: %s", new Object[]{executionStrategy}));
    }
}

