/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.executor;

import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.benchmark.event.BenchmarkQueryEvent;
import com.facebook.presto.benchmark.executor.QueryExecutor;
import com.facebook.presto.benchmark.framework.BenchmarkQuery;
import com.facebook.presto.benchmark.framework.BenchmarkRunnerConfig;
import com.facebook.presto.benchmark.framework.QueryException;
import com.facebook.presto.benchmark.prestoaction.PrestoAction;
import com.facebook.presto.benchmark.prestoaction.PrestoActionFactory;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class BenchmarkQueryExecutor
implements QueryExecutor {
    private static final Logger log = Logger.get(BenchmarkQueryExecutor.class);
    private final PrestoActionFactory prestoActionFactory;
    private final SqlParser sqlParser;
    private final ParsingOptions parsingOptions;
    private final Set<EventClient> eventClients;
    private final String testId;

    @Inject
    public BenchmarkQueryExecutor(PrestoActionFactory prestoActionFactory, SqlParser sqlParser, ParsingOptions parsingOptions, Set<EventClient> eventClients, BenchmarkRunnerConfig benchmarkRunnerConfig) {
        this.prestoActionFactory = Objects.requireNonNull(prestoActionFactory, "prestoAction is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.parsingOptions = Objects.requireNonNull(parsingOptions, "parsingOptions is null");
        this.eventClients = Objects.requireNonNull(eventClients, "eventClients is null");
        this.testId = Objects.requireNonNull(benchmarkRunnerConfig, "testId is null").getTestId();
    }

    @Override
    public BenchmarkQueryEvent run(BenchmarkQuery benchmarkQuery, Map<String, String> sessionProperties) {
        QueryStats queryStats = null;
        Statement statement = this.sqlParser.createStatement(benchmarkQuery.getQuery(), this.parsingOptions);
        PrestoAction prestoAction = this.prestoActionFactory.get(benchmarkQuery, sessionProperties);
        try {
            queryStats = prestoAction.execute(statement);
            return this.postEvent(this.buildEvent(benchmarkQuery, Optional.ofNullable(queryStats), Optional.empty()));
        }
        catch (QueryException e) {
            return this.postEvent(this.buildEvent(benchmarkQuery, Optional.ofNullable(queryStats), Optional.of(e)));
        }
        catch (Throwable t) {
            log.error(t);
            return this.postEvent(this.buildEvent(benchmarkQuery, Optional.ofNullable(queryStats), Optional.empty()));
        }
    }

    private BenchmarkQueryEvent buildEvent(BenchmarkQuery benchmarkQuery, Optional<QueryStats> queryStats, Optional<QueryException> queryException) {
        boolean succeeded = queryStats.isPresent();
        BenchmarkQueryEvent.Status status = succeeded ? BenchmarkQueryEvent.Status.SUCCEEDED : BenchmarkQueryEvent.Status.FAILED;
        Optional<String> errorCode = Optional.empty();
        String errorMessage = null;
        String stackTrace = null;
        if (!succeeded && queryException.isPresent()) {
            queryStats = queryException.get().getQueryStats();
            errorCode = queryException.get().getPrestoErrorCode().map(ErrorCodeSupplier::toErrorCode).map(ErrorCode::getName);
            errorMessage = queryException.get().getMessage();
            stackTrace = Throwables.getStackTraceAsString((Throwable)queryException.get().getCause());
        }
        return new BenchmarkQueryEvent(this.testId, benchmarkQuery.getName(), status, benchmarkQuery.getCatalog(), benchmarkQuery.getSchema(), benchmarkQuery.getQuery(), queryStats, errorCode, Optional.ofNullable(errorMessage), Optional.ofNullable(stackTrace));
    }

    private BenchmarkQueryEvent postEvent(BenchmarkQueryEvent event) {
        for (EventClient eventClient : this.eventClients) {
            eventClient.post((Object[])new BenchmarkQueryEvent[]{event});
        }
        return event;
    }
}

