/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.driver;

import com.facebook.presto.benchmark.driver.BenchmarkDriver;
import com.facebook.presto.benchmark.driver.BenchmarkDriverOptions;
import com.facebook.presto.benchmark.driver.BenchmarkQuery;
import com.facebook.presto.benchmark.driver.BenchmarkResultsPrinter;
import com.facebook.presto.benchmark.driver.BenchmarkResultsStore;
import com.facebook.presto.benchmark.driver.Suite;
import com.facebook.presto.client.ClientSession;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import io.airlift.command.Command;
import io.airlift.command.HelpOption;
import io.airlift.command.SingleCommand;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;

@Command(name="presto-benchmark", description="Presto benchmark driver")
public class PrestoBenchmarkDriver {
    @Inject
    public HelpOption helpOption;
    @Inject
    public BenchmarkDriverOptions benchmarkDriverOptions = new BenchmarkDriverOptions();

    public static void main(String[] args) throws Exception {
        new PrestoBenchmarkDriver().run(args);
    }

    protected void run(String[] args) throws Exception {
        PrestoBenchmarkDriver prestoBenchmarkDriver = (PrestoBenchmarkDriver)SingleCommand.singleCommand(PrestoBenchmarkDriver.class).parse(args);
        if (prestoBenchmarkDriver.helpOption.showHelpIfRequested()) {
            return;
        }
        BenchmarkDriverOptions driverOptions = prestoBenchmarkDriver.benchmarkDriverOptions;
        PrestoBenchmarkDriver.initializeLogging(driverOptions.debug);
        Object suites = Suite.readSuites(new File(driverOptions.suiteConfigFile));
        if (!driverOptions.suites.isEmpty()) {
            suites = suites.stream().filter(suite -> benchmarkDriverOptions.suites.contains(suite.getName())).collect(Collectors.toList());
        }
        suites = ImmutableList.copyOf(suites);
        File queriesDir = new File(driverOptions.sqlTemplateDir);
        List<BenchmarkQuery> allQueries = PrestoBenchmarkDriver.readQueries(queriesDir);
        Set<BenchmarkQuery> queries = driverOptions.queries.isEmpty() ? suites.stream().map(suite -> suite.selectQueries(allQueries)).flatMap(Collection::stream).collect(Collectors.toSet()) : driverOptions.queries.stream().map(Pattern::compile).map(pattern -> allQueries.stream().filter(query -> pattern.matcher(query.getName()).matches())).flatMap(Function.identity()).collect(Collectors.toSet());
        BenchmarkResultsStore resultsStore = this.getResultsStore((List<Suite>)suites, queries);
        ClientSession session = driverOptions.getClientSession();
        try (BenchmarkDriver benchmarkDriver = new BenchmarkDriver(resultsStore, session, queries, driverOptions.warm, driverOptions.runs, driverOptions.debug, driverOptions.maxFailures, Optional.ofNullable(driverOptions.socksProxy));){
            Iterator iterator = suites.iterator();
            while (iterator.hasNext()) {
                Suite suite2 = (Suite)iterator.next();
                benchmarkDriver.run(suite2);
            }
        }
    }

    protected BenchmarkResultsStore getResultsStore(List<Suite> suites, Set<BenchmarkQuery> queries) {
        return new BenchmarkResultsPrinter(suites, queries);
    }

    private static List<BenchmarkQuery> readQueries(File queriesDir) throws IOException {
        File[] files = queriesDir.listFiles();
        if (files == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder queries = ImmutableList.builder();
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".sql")) continue;
            queries.add((Object)new BenchmarkQuery(file));
        }
        return queries.build();
    }

    public static void initializeLogging(boolean debug) {
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            if (debug) {
                Logging logging = Logging.initialize();
                logging.configure(new LoggingConfiguration());
                logging.setLevel("com.facebook.presto", Logging.Level.DEBUG);
            } else {
                System.setOut(new PrintStream(ByteStreams.nullOutputStream()));
                System.setErr(new PrintStream(ByteStreams.nullOutputStream()));
                Logging logging = Logging.initialize();
                logging.configure(new LoggingConfiguration());
                logging.disableConsole();
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            System.setOut(out);
            System.setErr(err);
        }
    }
}

