/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.driver;

import com.facebook.presto.benchmark.driver.BenchmarkQuery;
import com.facebook.presto.benchmark.driver.Stat;
import com.facebook.presto.benchmark.driver.Suite;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;

public class BenchmarkQueryResult {
    private final Suite suite;
    private final BenchmarkQuery benchmarkQuery;
    private final Stat wallTimeNanos;
    private final Stat processCpuTimeNanos;
    private final Stat queryCpuTimeNanos;

    public BenchmarkQueryResult(Suite suite, BenchmarkQuery benchmarkQuery, Stat wallTimeNanos, Stat processCpuTimeNanos, Stat queryCpuTimeNanos) {
        this.suite = (Suite)Preconditions.checkNotNull((Object)suite, (Object)"suite is null");
        this.benchmarkQuery = (BenchmarkQuery)Preconditions.checkNotNull((Object)benchmarkQuery, (Object)"benchmarkQuery is null");
        this.wallTimeNanos = (Stat)Preconditions.checkNotNull((Object)wallTimeNanos, (Object)"wallTimeNanos is null");
        this.processCpuTimeNanos = (Stat)Preconditions.checkNotNull((Object)processCpuTimeNanos, (Object)"processCpuTimeNanos is null");
        this.queryCpuTimeNanos = (Stat)Preconditions.checkNotNull((Object)queryCpuTimeNanos, (Object)"queryCpuTimeNanos is null");
    }

    public Suite getSuite() {
        return this.suite;
    }

    public BenchmarkQuery getBenchmarkQuery() {
        return this.benchmarkQuery;
    }

    public Stat getWallTimeNanos() {
        return this.wallTimeNanos;
    }

    public Stat getProcessCpuTimeNanos() {
        return this.processCpuTimeNanos;
    }

    public Stat getQueryCpuTimeNanos() {
        return this.queryCpuTimeNanos;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("suite", (Object)this.suite.getName()).add("benchmarkQuery", (Object)this.benchmarkQuery.getName()).add("wallTimeMedian", (Object)new Duration(this.wallTimeNanos.getMedian(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("wallTimeMean", (Object)new Duration(this.wallTimeNanos.getMean(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("wallTimeStd", (Object)new Duration(this.wallTimeNanos.getStandardDeviation(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("processCpuTimeMedian", (Object)new Duration(this.processCpuTimeNanos.getMedian(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("processCpuTimeMean", (Object)new Duration(this.processCpuTimeNanos.getMean(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("processCpuTimeStd", (Object)new Duration(this.processCpuTimeNanos.getStandardDeviation(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("queryCpuTimeMedian", (Object)new Duration(this.queryCpuTimeNanos.getMedian(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("queryCpuTimeMean", (Object)new Duration(this.queryCpuTimeNanos.getMean(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("queryCpuTimeStd", (Object)new Duration(this.queryCpuTimeNanos.getStandardDeviation(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).toString();
    }
}

