/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.driver;

import com.facebook.presto.benchmark.driver.BenchmarkQuery;
import com.facebook.presto.benchmark.driver.Stat;
import com.facebook.presto.benchmark.driver.Suite;
import com.google.common.base.MoreObjects;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class BenchmarkQueryResult {
    private static final Stat FAIL_STAT = new Stat(new double[0]);
    private final Suite suite;
    private final BenchmarkQuery benchmarkQuery;
    private final Status status;
    private final Optional<String> errorMessage;
    private final Stat wallTimeNanos;
    private final Stat processCpuTimeNanos;
    private final Stat queryCpuTimeNanos;

    public static BenchmarkQueryResult passResult(Suite suite, BenchmarkQuery benchmarkQuery, Stat wallTimeNanos, Stat processCpuTimeNanos, Stat queryCpuTimeNanos) {
        return new BenchmarkQueryResult(suite, benchmarkQuery, Status.PASS, Optional.empty(), wallTimeNanos, processCpuTimeNanos, queryCpuTimeNanos);
    }

    public static BenchmarkQueryResult failResult(Suite suite, BenchmarkQuery benchmarkQuery, String errorMessage) {
        return new BenchmarkQueryResult(suite, benchmarkQuery, Status.FAIL, Optional.of(errorMessage), FAIL_STAT, FAIL_STAT, FAIL_STAT);
    }

    private BenchmarkQueryResult(Suite suite, BenchmarkQuery benchmarkQuery, Status status, Optional<String> errorMessage, Stat wallTimeNanos, Stat processCpuTimeNanos, Stat queryCpuTimeNanos) {
        this.suite = Objects.requireNonNull(suite, "suite is null");
        this.benchmarkQuery = Objects.requireNonNull(benchmarkQuery, "benchmarkQuery is null");
        this.status = Objects.requireNonNull(status, "status is null");
        this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage is null");
        this.wallTimeNanos = Objects.requireNonNull(wallTimeNanos, "wallTimeNanos is null");
        this.processCpuTimeNanos = Objects.requireNonNull(processCpuTimeNanos, "processCpuTimeNanos is null");
        this.queryCpuTimeNanos = Objects.requireNonNull(queryCpuTimeNanos, "queryCpuTimeNanos is null");
    }

    public Suite getSuite() {
        return this.suite;
    }

    public BenchmarkQuery getBenchmarkQuery() {
        return this.benchmarkQuery;
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public Stat getWallTimeNanos() {
        return this.wallTimeNanos;
    }

    public Stat getProcessCpuTimeNanos() {
        return this.processCpuTimeNanos;
    }

    public Stat getQueryCpuTimeNanos() {
        return this.queryCpuTimeNanos;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("suite", (Object)this.suite.getName()).add("benchmarkQuery", (Object)this.benchmarkQuery.getName()).add("status", (Object)this.status).add("wallTimeMedian", (Object)new Duration(this.wallTimeNanos.getMedian(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("wallTimeMean", (Object)new Duration(this.wallTimeNanos.getMean(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("wallTimeStd", (Object)new Duration(this.wallTimeNanos.getStandardDeviation(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("processCpuTimeMedian", (Object)new Duration(this.processCpuTimeNanos.getMedian(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("processCpuTimeMean", (Object)new Duration(this.processCpuTimeNanos.getMean(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("processCpuTimeStd", (Object)new Duration(this.processCpuTimeNanos.getStandardDeviation(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("queryCpuTimeMedian", (Object)new Duration(this.queryCpuTimeNanos.getMedian(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("queryCpuTimeMean", (Object)new Duration(this.queryCpuTimeNanos.getMean(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("queryCpuTimeStd", (Object)new Duration(this.queryCpuTimeNanos.getStandardDeviation(), TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit()).add("error", this.errorMessage).toString();
    }

    public static enum Status {
        PASS,
        FAIL;

    }
}

