/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.driver;

import com.facebook.presto.benchmark.driver.BenchmarkQuery;
import com.facebook.presto.benchmark.driver.BenchmarkSchema;
import com.facebook.presto.benchmark.driver.RegexTemplate;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class Suite {
    private final String name;
    private final Map<String, String> sessionProperties;
    private final List<RegexTemplate> schemaNameTemplates;
    private final List<Pattern> queryNamePatterns;

    public Suite(String name, Map<String, String> sessionProperties, Iterable<RegexTemplate> schemaNameTemplates, Iterable<Pattern> queryNamePatterns) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.sessionProperties = sessionProperties == null ? ImmutableMap.of() : ImmutableMap.copyOf(sessionProperties);
        this.schemaNameTemplates = ImmutableList.copyOf(Objects.requireNonNull(schemaNameTemplates, "schemaNameTemplates is null"));
        this.queryNamePatterns = ImmutableList.copyOf(Objects.requireNonNull(queryNamePatterns, "queryNamePatterns is null"));
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<RegexTemplate> getSchemaNameTemplates() {
        return this.schemaNameTemplates;
    }

    public List<Pattern> getQueryNamePatterns() {
        return this.queryNamePatterns;
    }

    public List<BenchmarkSchema> selectSchemas(Iterable<String> schemas) {
        if (this.schemaNameTemplates.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder benchmarkSchemas = ImmutableList.builder();
        for (RegexTemplate schemaNameTemplate : this.schemaNameTemplates) {
            for (String schema : schemas) {
                Optional<Map<String, String>> tags = schemaNameTemplate.parse(schema);
                if (!tags.isPresent()) continue;
                benchmarkSchemas.add((Object)new BenchmarkSchema(schema, tags.get()));
            }
        }
        return benchmarkSchemas.build();
    }

    public List<BenchmarkQuery> selectQueries(Iterable<BenchmarkQuery> queries) {
        if (this.getQueryNamePatterns().isEmpty()) {
            return ImmutableList.copyOf(queries);
        }
        List filteredQueries = StreamSupport.stream(queries.spliterator(), false).filter(query -> this.getQueryNamePatterns().stream().anyMatch(pattern -> pattern.matcher(query.getName()).matches())).collect(Collectors.toList());
        return ImmutableList.copyOf(filteredQueries);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("sessionProperties", this.sessionProperties).add("queryNamePatterns", this.queryNamePatterns).toString();
    }

    public static List<Suite> readSuites(File file) throws IOException {
        Objects.requireNonNull(file, "file is null");
        Preconditions.checkArgument((boolean)file.canRead(), (String)"Cannot read file: %s", (Object)file);
        byte[] json = Files.readAllBytes(file.toPath());
        Map options = (Map)JsonCodec.mapJsonCodec(String.class, OptionsJson.class).fromJson(json);
        ImmutableList.Builder runOptions = ImmutableList.builder();
        for (Map.Entry entry : options.entrySet()) {
            runOptions.add((Object)((OptionsJson)entry.getValue()).toSuite((String)entry.getKey()));
        }
        return runOptions.build();
    }

    public static class OptionsJson {
        private final List<String> schema;
        private final Map<String, String> session;
        private final List<String> query;

        @JsonCreator
        public OptionsJson(@JsonProperty(value="schema") List<String> schema, @JsonProperty(value="session") Map<String, String> session, @JsonProperty(value="query") List<String> query) {
            this.schema = ImmutableList.copyOf((Collection)Objects.requireNonNull(schema, "schema is null"));
            this.session = ImmutableMap.copyOf(Objects.requireNonNull(session, "session is null"));
            this.query = Objects.requireNonNull(query, "query is null");
        }

        public Suite toSuite(String name) {
            ImmutableList.Builder queryNameTemplates = ImmutableList.builder();
            for (String q : this.query) {
                queryNameTemplates.add((Object)Pattern.compile(q));
            }
            ImmutableList.Builder schemaNameTemplates = ImmutableList.builder();
            for (String s : this.schema) {
                schemaNameTemplates.add((Object)new RegexTemplate(s));
            }
            return new Suite(name, this.session, (Iterable<RegexTemplate>)schemaNameTemplates.build(), (Iterable<Pattern>)queryNameTemplates.build());
        }
    }
}

