/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.driver;

import com.facebook.presto.benchmark.driver.BenchmarkQuery;
import com.facebook.presto.benchmark.driver.BenchmarkQueryResult;
import com.facebook.presto.benchmark.driver.BenchmarkQueryRunner;
import com.facebook.presto.benchmark.driver.BenchmarkResultsStore;
import com.facebook.presto.benchmark.driver.BenchmarkSchema;
import com.facebook.presto.benchmark.driver.Suite;
import com.facebook.presto.client.ClientSession;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class BenchmarkDriver
implements Closeable {
    private final ClientSession clientSession;
    private final List<BenchmarkQuery> queries;
    private final BenchmarkResultsStore resultsStore;
    private final BenchmarkQueryRunner queryRunner;

    public BenchmarkDriver(BenchmarkResultsStore resultsStore, ClientSession clientSession, Iterable<BenchmarkQuery> queries, int warm, int runs, boolean debug, int maxFailures, Optional<HostAndPort> socksProxy) {
        this.resultsStore = Objects.requireNonNull(resultsStore, "resultsStore is null");
        this.clientSession = Objects.requireNonNull(clientSession, "clientSession is null");
        this.queries = ImmutableList.copyOf(Objects.requireNonNull(queries, "queries is null"));
        this.queryRunner = new BenchmarkQueryRunner(warm, runs, debug, maxFailures, clientSession.getServer(), socksProxy);
    }

    public void run(Suite suite) throws Exception {
        Object benchmarkSchemas;
        List<BenchmarkQuery> queries = suite.selectQueries(this.queries);
        if (queries.isEmpty()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(this.clientSession.getProperties());
        properties.putAll(suite.getSessionProperties());
        ClientSession session = ClientSession.withProperties((ClientSession)this.clientSession, properties);
        if (!suite.getSchemaNameTemplates().isEmpty()) {
            List<String> schemas = this.queryRunner.getSchemas(session);
            benchmarkSchemas = suite.selectSchemas(schemas);
        } else {
            benchmarkSchemas = ImmutableList.of((Object)new BenchmarkSchema(session.getSchema()));
        }
        if (benchmarkSchemas.isEmpty()) {
            return;
        }
        Iterator iterator = benchmarkSchemas.iterator();
        while (iterator.hasNext()) {
            BenchmarkSchema benchmarkSchema = (BenchmarkSchema)iterator.next();
            for (BenchmarkQuery benchmarkQuery : queries) {
                session = ClientSession.withCatalogAndSchema((ClientSession)session, (String)session.getCatalog(), (String)benchmarkSchema.getName());
                BenchmarkQueryResult result = this.queryRunner.execute(suite, session, benchmarkQuery);
                this.resultsStore.store(benchmarkSchema, result);
            }
        }
    }

    @Override
    public void close() {
        this.queryRunner.close();
    }
}

