/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.driver;

import com.facebook.presto.benchmark.driver.BenchmarkQuery;
import com.facebook.presto.benchmark.driver.BenchmarkQueryResult;
import com.facebook.presto.benchmark.driver.BenchmarkResultsStore;
import com.facebook.presto.benchmark.driver.BenchmarkSchema;
import com.facebook.presto.benchmark.driver.RegexTemplate;
import com.facebook.presto.benchmark.driver.Suite;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

public class BenchmarkResultsPrinter
implements BenchmarkResultsStore {
    private final List<String> tagNames;

    public BenchmarkResultsPrinter(Iterable<Suite> suites, Iterable<BenchmarkQuery> queries) {
        this(BenchmarkResultsPrinter.getSelectedQueryTagNames(suites, queries));
    }

    private static List<String> getSelectedQueryTagNames(Iterable<Suite> suites, Iterable<BenchmarkQuery> queries) {
        TreeSet<String> tags = new TreeSet<String>();
        for (Suite suite : suites) {
            for (BenchmarkQuery query : suite.selectQueries(queries)) {
                tags.addAll(query.getTags().keySet());
            }
            for (RegexTemplate regexTemplate : suite.getSchemaNameTemplates()) {
                tags.addAll(regexTemplate.getFieldNames());
            }
        }
        return ImmutableList.copyOf(tags);
    }

    public BenchmarkResultsPrinter(List<String> tagNames) {
        this.tagNames = Objects.requireNonNull(tagNames, "tagNames is null");
        BenchmarkResultsPrinter.printRow(ImmutableList.builder().add((Object)"suite").add((Object)"query").addAll(tagNames).add((Object)"wallTimeP50").add((Object)"wallTimeMean").add((Object)"wallTimeStd").add((Object)"processCpuTimeP50").add((Object)"processCpuTimeMean").add((Object)"processCpuTimeStd").add((Object)"queryCpuTimeP50").add((Object)"queryCpuTimeMean").add((Object)"queryCpuTimeStd").add((Object)"status").add((Object)"error").build());
    }

    @Override
    public void store(BenchmarkSchema benchmarkSchema, BenchmarkQueryResult result) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.putAll(result.getBenchmarkQuery().getTags());
        tags.putAll(benchmarkSchema.getTags());
        Optional<String> errorMessage = result.getErrorMessage().map(error -> (String)Iterables.getFirst((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\r\n")).trimResults().split((CharSequence)error), (Object)""));
        BenchmarkResultsPrinter.printRow(ImmutableList.builder().add((Object)result.getSuite().getName()).add((Object)result.getBenchmarkQuery().getName()).addAll(Iterables.transform(this.tagNames, (Function)Functions.forMap(tags, (Object)""))).add((Object)TimeUnit.NANOSECONDS.toMillis((long)result.getWallTimeNanos().getMedian())).add((Object)TimeUnit.NANOSECONDS.toMillis((long)result.getWallTimeNanos().getMean())).add((Object)TimeUnit.NANOSECONDS.toMillis((long)result.getWallTimeNanos().getStandardDeviation())).add((Object)TimeUnit.NANOSECONDS.toMillis((long)result.getProcessCpuTimeNanos().getMedian())).add((Object)TimeUnit.NANOSECONDS.toMillis((long)result.getProcessCpuTimeNanos().getMean())).add((Object)TimeUnit.NANOSECONDS.toMillis((long)result.getProcessCpuTimeNanos().getStandardDeviation())).add((Object)TimeUnit.NANOSECONDS.toMillis((long)result.getQueryCpuTimeNanos().getMedian())).add((Object)TimeUnit.NANOSECONDS.toMillis((long)result.getQueryCpuTimeNanos().getMean())).add((Object)TimeUnit.NANOSECONDS.toMillis((long)result.getQueryCpuTimeNanos().getStandardDeviation())).add((Object)result.getStatus().toString().toLowerCase()).add((Object)errorMessage.orElse("")).build());
    }

    private static void printRow(Iterable<?> values) {
        System.out.println(Joiner.on((char)'\t').join(values));
    }
}

