/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.benchmark.driver;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class BenchmarkQuery {
    private static final Splitter SECTION_SPLITTER = Splitter.on((Pattern)Pattern.compile("\n\\s*=+\\s*\n", 8)).limit(2).trimResults();
    private static final Splitter.MapSplitter TAGS_SPLITTER = Splitter.on((String)"\n").trimResults().withKeyValueSeparator('=');
    private final String name;
    private final Map<String, String> tags;
    private final String sql;

    public BenchmarkQuery(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"file is null");
        this.name = Files.getNameWithoutExtension((String)file.getName());
        String text = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
        List sections = SECTION_SPLITTER.splitToList((CharSequence)text);
        if (sections.size() == 2) {
            this.tags = ImmutableMap.copyOf((Map)TAGS_SPLITTER.split((CharSequence)sections.get(0)));
            this.sql = (String)sections.get(1);
        } else {
            this.tags = ImmutableMap.of();
            this.sql = (String)sections.get(0);
        }
    }

    public static Function<BenchmarkQuery, String> queryNameGetter() {
        return query -> query.getName();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getSql() {
        return this.sql;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("tags", this.tags).add("sql", (Object)this.sql).toString();
    }
}

