/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public final class JdbcTableHandle
implements ConnectorTableHandle {
    private final String connectorId;
    private final SchemaTableName schemaTableName;
    private final String catalogName;
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public JdbcTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="catalogName") @Nullable String catalogName, @JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="tableName") String tableName) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.schemaTableName = (SchemaTableName)Preconditions.checkNotNull((Object)schemaTableName, (Object)"schemaTableName is null");
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    @Nullable
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JdbcTableHandle o = (JdbcTableHandle)obj;
        return Objects.equal((Object)this.connectorId, (Object)o.connectorId) && Objects.equal((Object)this.schemaTableName, (Object)o.schemaTableName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connectorId, this.schemaTableName});
    }

    public String toString() {
        return Joiner.on((String)":").useForNull("null").join((Object)this.connectorId, (Object)this.schemaTableName, new Object[]{this.catalogName, this.schemaName, this.tableName});
    }
}

