/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.jdbc;

import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.jdbc.JdbcColumnHandle;
import com.facebook.presto.plugin.jdbc.JdbcRecordSet;
import com.facebook.presto.plugin.jdbc.JdbcSplit;
import com.facebook.presto.plugin.jdbc.Types;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;

public class JdbcRecordSetProvider
implements ConnectorRecordSetProvider {
    private final JdbcClient jdbcClient;

    @Inject
    public JdbcRecordSetProvider(JdbcClient jdbcClient) {
        this.jdbcClient = (JdbcClient)Preconditions.checkNotNull((Object)jdbcClient, (Object)"jdbcClient is null");
    }

    public RecordSet getRecordSet(ConnectorSplit split, List<? extends ConnectorColumnHandle> columns) {
        JdbcSplit jdbcSplit = Types.checkType(split, JdbcSplit.class, "split");
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ConnectorColumnHandle connectorColumnHandle : columns) {
            handles.add((Object)Types.checkType(connectorColumnHandle, JdbcColumnHandle.class, "columnHandle"));
        }
        return new JdbcRecordSet(this.jdbcClient, jdbcSplit, (List<JdbcColumnHandle>)handles.build());
    }
}

